\name{breslow}
\alias{breslow}
\title{Breslow estimator for cumulative baseline hazard rate}
\description{This function calculates the Breslow estimator for the
  cumulative baseline hazard rate, given fitted linear predictor values.}
\usage{
breslow(f, riskset, entry, exit, trans, event)
}
\arguments{
\item{f}{ fitted linear predictor values}
\item{riskset}{ riskset list as generated by \code{buildrisksets}.}
\item{entry}{ entry times.}
\item{exit}{ exit times.}
\item{trans}{ transition index.}
\item{event}{ observed event indicator.}
}
\details{This function calculates the Breslow estimator for the
  cumulative baseline hazard rate, given fitted linear predictor values.}
\value{ 
A list of length Q with each element including including elements
\item{times}{ a vector of observed event times,}
\item{cbhr}{ a vector of calculated cumulative hazard rate values.}
}
\author{Holger Reulen}
\examples{
\dontrun{breslow(f, riskset, entry, exit, trans, event)}
}
