% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdGenerate.R
\name{gdGenerateParameters}
\alias{gdGenerateParameters}
\title{Specify parameters for generation of generative data}
\usage{
gdGenerateParameters(
  numberOfIterations = 50000,
  numberOfHiddenLayerUnits = 1024,
  learningRate = 1e-04,
  keepProbability = 0.95,
  collectBeginningAtIteration = 1
)
}
\arguments{
\item{numberOfIterations}{Number of training steps}

\item{numberOfHiddenLayerUnits}{Number of hidden layer units}

\item{learningRate}{Learning rate for training of neural networks}

\item{keepProbability}{Value in the range of 0 to 1 which is used to train
generalized neural networks.}

\item{collectBeginningAtIteration}{Collect generative data beginning at
iteration}
}
\value{
List of parameters for generation of generative data
}
\description{
Specify parameters for training of neural networks used for generation of
generative data. These parameters are passed to function gdGenerate().
}
\examples{
\dontrun{
generateParameters <- gdGenerateParameters(numberOfIterations = 5000)}
}
