% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Segment-generics.R, R/Segment-methods.R
\docType{methods}
\name{DynSegment}
\alias{DynSegment}
\alias{DynSegment,ANY-method}
\alias{DynSegment,gaDynSegment-method}
\title{DynSegment}
\usage{
DynSegment(object, ..., name = character(0))

\S4method{DynSegment}{ANY}(object, ..., name = character(0))

\S4method{DynSegment}{gaDynSegment}(object)
}
\arguments{
\item{object}{The first filter to include in the segment definition.}

\item{...}{Additional filters to include in the segment definition, if
needed.}

\item{name}{An optional name given to the dynamic segment.}
}
\value{
A \code{gaDynSegment} object.
}
\description{
Combine one or more segment condition filters and/or sequence filters into a
\code{gaDynSegment} that is scoped to either \code{'user'} or
\code{'session'} level.
}
\details{
Segment filter are either sequential or non-sequential conditions.
Sequential and non-sequential conditions can be combined using this function.
}
\section{Methods (by class)}{
\itemize{
\item \code{ANY}: Defines a list of filters from one or more
expressions applied using the specified scope.

\item \code{gaDynSegment}: Returns itself.
}}

\examples{
return_shoppers <- SegmentConditionFilter(
  Expr(~transactions > 1, metricScope = "perUser"),
  scope = "users"
)
watched_video_then_purchased <- Sequence(
  Expr(~eventCategory == "video") & Expr(~eventAction == "play"),
  Later(Expr(~transactions > 0))
)

}
\seealso{
Other dynamic segment functions: \code{\link{Exclude}},
  \code{\link{Include}}, \code{\link{IsNegated}},
  \code{\link{PerHit}}, \code{\link{PerProduct}},
  \code{\link{PerSession}}, \code{\link{PerUser}},
  \code{\link{ScopeLevel}},
  \code{\link{SegmentConditionFilter}},
  \code{\link{Segments}}, \code{\link{Segment}}
}
\concept{dynamic segment functions}
