% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ESplot.R
\name{ESplot}
\alias{ESplot}
\title{Effect-size plot}
\usage{
ESplot(ESdat, alpha = 0.05, fontsize = 12)
}
\arguments{
\item{ESdat}{A data frame consisting of model id, parameter estimates and standard errors.}

\item{alpha}{Type-I error rate used to construct 100(1-alpha) confidence interval.}

\item{fontsize}{size of font.}
}
\value{
A high resolution plot object.
}
\description{
The function accepts parameter estimates and their standard errors for a range of models.
}
\examples{
rs12075 <- data.frame(id=c("CCL2","CCL7","CCL8","CCL11","CCL13","CXCL6","Monocytes"),
                      b=c(0.1694,-0.0899,-0.0973,0.0749,0.189,0.0816,0.0338387),
                      se=c(0.0113,0.013,0.0116,0.0114,0.0114,0.0115,0.00713386))
ESplot(rs12075)

# The function replaces an older implementation.
within(data.frame(
       id=c("Basic model","Adjusted","Moderately adjusted","Heavily adjusted","Other"),
       b=log(c(4.5,3.5,2.5,1.5,1)),
       se=c(0.2,0.1,0.2,0.3,0.2)
), {
   lcl <- exp(b-1.96*se)
   ucl <- exp(b+1.96*se)
   x <- seq(-2,8,length=length(id))
   y <- 1:length(id)
   plot(x,y,type="n",xlab="",ylab="",axes=FALSE)
   points((lcl+ucl)/2,y,pch=22,bg="black",cex=3)
   segments(lcl,y,ucl,y,lwd=3,lty="solid")
   axis(1,cex.axis=1.5,lwd=0.5)
   par(las=1)
   abline(v=1)
   axis(2,labels=id,at=y,lty="blank",hadj=0.2,cex.axis=1.5)
   title("A fictitious plot")
})
}
\author{
Jing Hua Zhao
}
\keyword{hplot}
