% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factory.R
\name{get_factory_cals}
\alias{get_factory_cals}
\title{Returns a matrix with factory calibration information for given instrument
serial numbers and calibration dates.}
\usage{
get_factory_cals(sn = NULL, datetime = NULL)
}
\arguments{
\item{sn}{a character vector with an instrument serial number. If named, the
names are kept in the output.}

\item{datetime}{a POSIXct time vector indicating the latest possible time for
the calibration data that is to be returned. If no calibration before
datetime is found, the oldest available calibration is returned.}
}
\value{
A character matrix with factory calibration data. If no datetime is
provided, the newest calibration is returned.
}
\description{
The factory calibration of the 6800 can be used to calculate
concentrations from raw values. If calibration information is available in
the package environment it can be retrieved by this method.
}
\details{
The datetime option can be used to make sure that newer calibration
files are not used in combination with older datafiles.
}
\examples{
exampledir <- system.file("extdata//", package = "gasanalyzer")

# import factory cals for example data:
import_factory_cals(exampledir)

# show calibration data for a specific instrument serial numbers, closest to
# the current time:
get_factory_cals(sn = "68H-422400", datetime=Sys.time())
}
