% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equations.R
\name{modify_equations}
\alias{modify_equations}
\title{Modify an existing list of equations with specific user-specified equations.}
\usage{
modify_equations(eqs, ...)
}
\arguments{
\item{eqs}{a list of calls for recomputing \code{gasanalyzer} equations.}

\item{...}{custom equations. the arguments must tagged function expressions.
The tags will be matched against the equation list specified in eqs, and
matching expressions will be replaced. Additional expressions will be
added to the list. Note that the function body must be wrapped in curly
brackets.}
}
\value{
A modified list of calls containing equations to recalculate
\code{gasanalyzer} data.
}
\description{
This method allows replacing a specific equations in a list with
custom versions. Although it is possible to add custom equations using
\code{\link[=create_equations]{create_equations()}}, it can be useful to modify existing sets. It can also
be used to modify equations imported from an \code{xlsx} file.
}
\examples{
exampledir <- system.file("extdata", package = "gasanalyzer")

# import factory calibration for example data:
import_factory_cals(exampledir)

# read data from a txt file:
li6800 <- read_6800_txt(file.path(exampledir, "lowo2"))

# create a default set of gas-exchange equations, for the Li-6800:
Eqs <- create_equations(c("default", "li6800"))

# replace the value for the leaf light absorptance:
Eqs <- modify_equations(Eqs, LeafQ.alpha = \() {0.86})

# apply:
li6800_recalc <- recalculate(li6800, Eqs)

li6800$LeafQ.alpha
li6800_recalc$LeafQ.alpha
}
\seealso{
\code{\link[=read_6800_equations]{read_6800_equations()}}
}
