% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_wrappers.R
\name{wrappers_hessian}
\alias{wrappers_hessian}
\alias{wrapper_hessian_stats}
\alias{wrapper_hessian_pracma}
\alias{wrapper_hessian_numderiv}
\title{Wrappers for Hessian Functions}
\usage{
wrapper_hessian_stats(obj_fun, theta_optim, ...)

wrapper_hessian_pracma(obj_fun, theta_optim, ...)

wrapper_hessian_numderiv(obj_fun, theta_optim, ...)
}
\arguments{
\item{obj_fun}{An objective function.}

\item{theta_optim}{A numeric vector of the optimal values of the variables.}

\item{...}{Additional arguments to be passed to the Hessian function. These include arguments required by the objective function, namely \code{est_details} and \code{print_progress}.}
}
\value{
A list with components:
  \item{status_hessian}{The status of the Hessian computation.}
  \item{theta_hessian}{The Hessian matrix.}
}
\description{
Wrappers of common R Hessian functions.
Their purpose is to be passed as the \code{hessian_function} argument in the \code{\link[gasmodel:gas]{gas()}} function.
}
\section{Functions}{
\itemize{
\item \code{wrapper_hessian_stats()}: Wrapper for Hessian function \code{\link[stats:optimHess]{stats::optimHess()}}.

\item \code{wrapper_hessian_pracma()}: Wrapper for Hessian function \code{\link[pracma:hessian]{pracma::hessian()}}.

\item \code{wrapper_hessian_numderiv()}: Wrapper for Hessian function \code{\link[numDeriv:hessian]{numDeriv::hessian()}}.

}}
\seealso{
\code{\link[gasmodel:gas]{gas()}}
\code{\link[gasmodel:wrappers_optim]{wrappers_optim}}
}
