% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fr1st.R
\name{fr1st}
\alias{fr1st}
\title{Robust stepwise selection of covariates}
\usage{
fr1st(y,x,cn=1,cnr=c(1,3,5),p0=0.01,sg=0,nu=1,kmx=0,mx=21,kex=0,sub=T,inr=T,xinr=F,red=F)
}
\arguments{
\item{y}{Dependent variable}

\item{x}{Covariates}

\item{cn}{The constant for Huber's psi-function}

\item{cnr}{The constants for Hampel's three part redescending psi function}

\item{p0}{The P-value cut-off}

\item{sg}{ Scale value of residuals}

\item{nu}{The order for calculating the P-value}

\item{kmx}{The maximum number of included covariates}

\item{mx}{The maximum number of included covariates if the option subset =TRUE is used}

\item{kex}{The excluded covariates}

\item{sub}{Logical, if TRUE best subset selected}

\item{inr}{Logical TRUE to include intercept}

\item{xinr}{Logical TRUE if intercept already included}

\item{red}{Logical If true Hampel's three part redescending psi function}
}


\value{
pv In order the subset ind, the regression coefficients, the Gaussian P-values, the standard P-values.

res The residuals

stpv  The stepwise regression results: covariate, P-value and scale 
}
\description{
Robust stepwise selection of covariates 
}
\examples{
data(boston)
 a<-fr1st(boston[,14],boston[,1:13],kex=7:8)
}
