% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_nist.R
\name{comp_nist}
\alias{comp_nist}
\title{Compares MS to NIST MS database}
\usage{
comp_nist(nistlist, ms, cutoff = 50, title = "Best NIST match")
}
\arguments{
\item{nistlist}{a \emph{list} object, a list of compound MS data from the
NIST MS Library database, ideally the output of nist_list().}

\item{ms}{a \emph{data.frame} object, a data frame of the mass values and the
percent intensity values, ideally the output of find_ms().}

\item{cutoff}{a \emph{float} object, the low end cutoff for the MS data,
determined based on the MS devices used for analysis. Default is 50.}

\item{title}{a \emph{string} object. Title placed at the top of the
head-to-tail plot of best NIST Library match. Default title "Best NIST match".}
}
\value{
a \emph{data.frame} object, a list of the top 10 best matching
compounds from the NIST database, with their compounds, the index in the
nistlist, and match percent.
}
\description{
\code{comp_nist} compares the MS data from a peak to the NIST MS
database.
}
\details{
This function takes the MS data from an intensity peak in a sample
and compares it to the NIST MS Library database and determines the compound
which is the best match to the MS data.
}
