% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_collection.R
\name{add_images}
\alias{add_images}
\title{Add images to an existing image collection}
\usage{
add_images(
  image_collection,
  files,
  unroll_archives = TRUE,
  out_file = "",
  quiet = FALSE
)
}
\arguments{
\item{image_collection}{image_collection object or path to an existing collection file}

\item{files}{character vector with paths to image files on disk or any GDAL dataset identifiers (including virtual file systems and higher level drivers or GDAL subdatasets)}

\item{unroll_archives}{automatically convert .zip, .tar archives and .gz compressed files to GDAL virtual file system dataset identifiers (e.g. by prepending /vsizip/) and add contained files to the list of considered files}

\item{out_file}{path to output file, an empty string (the default) will update the collection in-place, whereas images will be added to a new copy of the image collection at the given location otherwise.}

\item{quiet}{logical; if TRUE, do not print resulting image collection if return value is not assigned to a variable}
}
\value{
image collection proxy object, which can be used to create a data cube using \code{\link{raster_cube}}
}
\description{
This function adds provided files or GDAL dataset identifiers and to an existing image collection by extracting datetime, image identifiers, and band information according to the collection's format.
}
\examples{
L8_files <- list.files(system.file("L8NY18", package = "gdalcubes"),
                         ".TIF", recursive = TRUE, full.names = TRUE)
L8_col = create_image_collection(L8_files[1:12], "L8_L1TP") 
add_images(L8_col, L8_files[13:24])
}
