% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduce.R
\name{reduce_space.cube}
\alias{reduce_space.cube}
\title{Reduce a data cube over spatial (x,y or lat,lon) dimensions}
\usage{
\method{reduce_space}{cube}(x, expr, ..., FUN, names = NULL)
}
\arguments{
\item{x}{source data cube}

\item{expr}{either a single string, or a vector of strings defining which reducers will be applied over which bands of the input cube}

\item{...}{optional additional expressions (if \code{expr} is not a vector)}

\item{FUN}{a user-defined R function applied over pixel time series (see Details)}

\item{names}{character vector; if FUN is provided, names can be used to define the number and name of output bands}
}
\value{
proxy data cube object
}
\description{
Create a proxy data cube, which applies one or more reducer functions to selected bands over spatial slices of a data cube
}
\details{
Notice that expressions have a very simple format: the reducer is followed by the name of a band in parantheses. You cannot add
more complex functions or arguments.

Possible reducers currently are "min", "max", "sum", "prod", "count", "mean", "median", "var", "sd".
}
\note{
Implemented reducers will ignore any NAN values (as na.rm=TRUE does).

This function returns a proxy object, i.e., it will not start any computations besides deriving the shape of the result.
}
\examples{
# create image collection from example Landsat data only 
# if not already done in other examples
if (!file.exists(file.path(tempdir(), "L8.db"))) {
  L8_files <- list.files(system.file("L8NY18", package = "gdalcubes"),
                         ".TIF", recursive = TRUE, full.names = TRUE)
  create_image_collection(L8_files, "L8_L1TP", file.path(tempdir(), "L8.db"), quiet = TRUE) 
}

L8.col = image_collection(file.path(tempdir(), "L8.db"))
v = cube_view(extent=list(left=388941.2, right=766552.4, 
              bottom=4345299, top=4744931, t0="2018-01", t1="2018-12"),
              srs="EPSG:32618", nx = 497, ny=526, dt="P1M")
L8.cube = raster_cube(L8.col, v) 
L8.b02 = select_bands(L8.cube, c("B02"))
L8.b02.median = reduce_space(L8.b02, "median(B02)")  
L8.b02.median
\donttest{
plot(L8.b02.median)
}

}
