% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{inv_project}
\alias{inv_project}
\title{Inverse project geospatial x/y coordinates to longitude/latitude}
\usage{
inv_project(pts, srs, well_known_gcs = "")
}
\arguments{
\item{pts}{A two-column data frame or numeric matrix containing geospatial
x/y coordinates}

\item{srs}{Character string in OGC WKT format specifying the projected
spatial reference system for \code{pts}.}

\item{well_known_gcs}{Optional character string containing a supported
well known name of a geographic coordinate system (see Details for
supported values).}
}
\value{
Numeric array of longitude, latitude. An error is raised if the
transformation cannot be performed.
}
\description{
\code{inv_project()} transforms geospatial x/y coordinates to
longitude/latitude in the same geographic coordinate system used by the
given projected spatial reference system. The output long/lat can
optionally be set to a specific geographic coordinate system by specifying
a well known name (see Details).
}
\details{
By default, the geographic coordinate system of the projection specified
by \code{srs} will be used. If a specific geographic coordinate system is
desired, then \code{well_known_gcs} can be set to one of the values below:
\tabular{rl}{
\code{EPSG:n} \tab where \code{n} is the code of a geographic CRS\cr
\code{WGS84}  \tab same as \code{EPSG:4326}\cr
\code{WGS72}  \tab same as \code{EPSG:4322}\cr
\code{NAD83}  \tab same as \code{EPSG:4269}\cr
\code{NAD27}  \tab same as \code{EPSG:4267}\cr
\code{CRS84}  \tab same as \code{WGS84}\cr
\code{CRS72}  \tab same as \code{WGS72}\cr
\code{CRS27}  \tab same as \code{NAD27}
}
The returned array will always be in longitude, latitude order
(traditional GIS order) regardless of the axis order defined for the
names above.
}
\examples{
pt_file <- system.file("extdata/storml_pts.csv", package="gdalraster")
## id, x, y in NAD83 / UTM zone 12N
pts <- read.csv(pt_file)
print(pts)
inv_project(pts[,-1], epsg_to_wkt(26912))
inv_project(pts[,-1], epsg_to_wkt(26912), "NAD27")
}
\seealso{
\code{\link[=transform_xy]{transform_xy()}}
}
