# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Get GDAL version
#'
#' `gdal_version()` returns runtime version information.
#'
#' @returns Character vector of length four containing:
#'   * "–version" - one line version message, e.g., “GDAL 3.6.3, released 
#'   2023/03/12”
#'   * "GDAL_VERSION_NUM" - formatted as a string, e.g., “3060300” for 
#'   GDAL 3.6.3.0
#'   * "GDAL_RELEASE_DATE" - formatted as a string, e.g., “20230312”
#'   * "GDAL_RELEASE_NAME" - e.g., “3.6.3”
#' @examples
#' gdal_version()
gdal_version <- function() {
    .Call(`_gdalraster_gdal_version`)
}

#' Report all configured GDAL drivers for raster formats
#'
#' `gdal_formats()` prints to the console a list of the supported raster
#' formats.
#'
#' @returns No return value, called for reporting only.
#' @examples
#' gdal_formats()
gdal_formats <- function() {
    invisible(.Call(`_gdalraster_gdal_formats`))
}

#' Get GDAL configuration option
#'
#' `get_config_option()` gets the value of GDAL runtime configuration option.
#' Configuration options are essentially global variables the user can set.
#' They are used to alter the default behavior of certain raster format 
#' drivers, and in some cases the GDAL core. For a full description and 
#' listing of available options see 
#' \url{https://gdal.org/user/configoptions.html}.
#'
#' @param key Character name of a configuration option.
#' @returns Character. The value of a (key, value) option previously set with 
#' `set_config_option()`. An empty string (`""`) is returned if `key` is not 
#' found.
#'
#' @seealso
#' [set_config_option()]
#'
#' `vignette("gdal-config-quick-ref")`
#'
#' @examples
#' ## this option is set during initialization of the gdalraster package
#' get_config_option("OGR_CT_FORCE_TRADITIONAL_GIS_ORDER")
get_config_option <- function(key) {
    .Call(`_gdalraster_get_config_option`, key)
}

#' Set GDAL configuration option
#'
#' `set_config_option()` sets a GDAL runtime configuration option. 
#' Configuration options are essentially global variables the user can set.
#' They are used to alter the default behavior of certain raster format 
#' drivers, and in some cases the GDAL core. For a full description and 
#' listing of available options see 
#' \url{https://gdal.org/user/configoptions.html}.
#'
#' @param key Character name of a configuration option.
#' @param value Character value to set for the option. 
#' `value = ""` (empty string) will unset a value previously set by 
#' `set_config_option()`.
#' @returns No return value, called for side effects.
#'
#' @seealso
#' [get_config_option()]
#'
#' `vignette("gdal-config-quick-ref")`
#'
#' @examples
#' set_config_option("GDAL_CACHEMAX", "10%")
#' get_config_option("GDAL_CACHEMAX")
#' ## unset:
#' set_config_option("GDAL_CACHEMAX", "")
set_config_option <- function(key, value) {
    invisible(.Call(`_gdalraster_set_config_option`, key, value))
}

#' Get the size of memory in use by the GDAL block cache
#'
#' `get_cache_used()` returns the amount of memory currently in use for
#' GDAL block caching. This a wrapper for `GDALGetCacheUsed64()` with return
#' value as MB.
#'
#' @returns Integer. Amount of cache memory in use in MB.
#'
#' @seealso
#' [GDAL Block Cache](https://usdaforestservice.github.io/gdalraster/articles/gdal-block-cache.html)
#'
#' @examples
#' get_cache_used()
get_cache_used <- function() {
    .Call(`_gdalraster_get_cache_used`)
}

#' Create a new uninitialized raster
#'
#' `create()` makes an empty raster in the specified format.
#'
#' @param format Raster format short name (e.g., "GTiff").
#' @param dst_filename Filename to create.
#' @param xsize Integer width of raster in pixels.
#' @param ysize Integer height of raster in pixels.
#' @param nbands Integer number of bands.
#' @param dataType Character data type name.
#' (e.g., common data types include Byte, Int16, UInt16, Int32, Float32).
#' @param options Optional list of format-specific creation options in a
#' vector of `"NAME=VALUE"` pairs 
#' (e.g., \code{options = c("COMPRESS=LZW")} to set LZW 
#' compression during creation of a GTiff file).
#' The APPEND_SUBDATASET=YES option can be 
#' specified to avoid prior destruction of existing dataset.
#' @returns Logical indicating success (invisible \code{TRUE}).
#' An error is raised if the operation fails.
#' @seealso
#' [`GDALRaster-class`][GDALRaster], [createCopy()], [rasterFromRaster()],
#' [getCreationOptions()]
#' @examples
#' new_file <- paste0(tempdir(), "/", "newdata.tif")
#' create(format="GTiff", dst_filename=new_file, xsize=143, ysize=107,
#'        nbands=1, dataType="Int16")
#' ds <- new(GDALRaster, new_file, read_only=FALSE)
#' ## EPSG:26912 - NAD83 / UTM zone 12N
#' ds$setProjection(epsg_to_wkt(26912))
#' gt <- c(323476.1, 30, 0, 5105082.0, 0, -30)
#' ds$setGeoTransform(gt)
#' ds$setNoDataValue(band = 1, -9999)
#' ds$fillRaster(band = 1, -9999, 0)
#' ## ...
#' ## close the dataset when done
#' ds$close()
create <- function(format, dst_filename, xsize, ysize, nbands, dataType, options = NULL) {
    invisible(.Call(`_gdalraster_create`, format, dst_filename, xsize, ysize, nbands, dataType, options))
}

#' Create a copy of a raster
#'
#' `createCopy()` copies a raster dataset, optionally changing the format.
#' The extent, cell size, number of bands, data type, projection, and 
#' geotransform are all copied from the source raster.
#'
#' @param format Format short name for the output raster 
#' (e.g., "GTiff" or "HFA").
#' @param dst_filename Filename to create.
#' @param src_filename Filename of source raster.
#' @param strict Logical. TRUE if the copy must be strictly equivalent, 
#' or more normally FALSE indicating that the copy may adapt as needed for  
#' the output format.
#' @param options Optional list of format-specific creation options in a
#' vector of `"NAME=VALUE"` pairs 
#' (e.g., \code{options = c("COMPRESS=LZW")} to set \code{LZW}
#' compression during creation of a GTiff file).
#' The APPEND_SUBDATASET=YES option can be 
#' specified to avoid prior destruction of existing dataset.
#' @returns Logical indicating success (invisible \code{TRUE}).
#' An error is raised if the operation fails.
#' @seealso
#' [`GDALRaster-class`][GDALRaster], [create()], [rasterFromRaster()],
#' [getCreationOptions()], [translate()]
#' @examples
#' lcp_file <- system.file("extdata/storm_lake.lcp", package="gdalraster")
#' tif_file <- paste0(tempdir(), "/", "storml_lndscp.tif")
#' opt <- c("COMPRESS=LZW")
#' createCopy(format="GTiff", dst_filename=tif_file, src_filename=lcp_file,
#'            options=opt)
#' file.size(lcp_file)
#' file.size(tif_file)
#' ds <- new(GDALRaster, tif_file, read_only=FALSE)
#' ds$getMetadata(band=0, domain="IMAGE_STRUCTURE")
#' for (band in 1:ds$getRasterCount())
#'     ds$setNoDataValue(band, -9999)
#' ds$getStatistics(band=1, approx_ok=FALSE, force=TRUE)
#' ds$close()
createCopy <- function(format, dst_filename, src_filename, strict = FALSE, options = NULL) {
    invisible(.Call(`_gdalraster_createCopy`, format, dst_filename, src_filename, strict, options))
}

#' Apply geotransform
#'
#' `_apply_geotransform()` applies geotransform coefficients to a raster 
#' coordinate in pixel/line space (colum/row), converting into a 
#' georeferenced (x, y) coordinate.
#'
#' @param gt Numeric vector of length six containing the geotransform to 
#' apply.
#' @param pixel Numeric scalar. A raster pixel (column) coordinate.
#' @param line Numeric scalar. A raster line (row) coordinate.
#' @returns Numeric vector of length two containing a geospatial x/y 
#' coordinate (spatial reference system of `gt`).
#' @seealso [`GDALRaster$getGeoTransform()`][GDALRaster], [get_pixel_line()], 
#' [inv_geotransform()]
#' @noRd
.apply_geotransform <- function(gt, pixel, line) {
    .Call(`_gdalraster__apply_geotransform`, gt, pixel, line)
}

#' Invert geotransform
#'
#' `inv_geotransform()` inverts a vector of geotransform coefficients. This 
#' converts the equation from being:\cr
#' raster pixel/line (column/row) -> geospatial x/y coordinate\cr
#' to:\cr
#' geospatial x/y coordinate -> raster pixel/line (column/row)
#'
#' @param gt Numeric vector of length six containing the geotransform to 
#' invert.
#' @returns Numeric vector of length six containing the inverted 
#' geotransform. The output vector will contain NAs if the input geotransform
#' is uninvertable.
#' @seealso [`GDALRaster$getGeoTransform()`][GDALRaster], [get_pixel_line()]
#' @examples
#' elev_file <- system.file("extdata/storml_elev.tif", package="gdalraster")
#' ds <- new(GDALRaster, elev_file, read_only=TRUE)
#' gt <- ds$getGeoTransform()
#' ds$close()
#' invgt <- inv_geotransform(gt)
#' 
#' ptX = 324181.7
#' ptY = 5103901.4
#' 
#' ## for a point x, y in the spatial reference system of elev_file
#' ## raster pixel (column number):
#' pixel <- floor(invgt[1] +
#'                invgt[2] * ptX +
#'                invgt[3] * ptY)
#' 
#' ## raster line (row number):
#' line <- floor(invgt[4] +
#'               invgt[5] * ptX +
#'               invgt[6] * ptY)
#' 
#' ## get_pixel_line() applies this conversion
inv_geotransform <- function(gt) {
    .Call(`_gdalraster_inv_geotransform`, gt)
}

#' Raster pixel/line from geospatial x,y coordinates
#'
#' `get_pixel_line()` converts geospatial coordinates to pixel/line (raster 
#' column, row numbers).
#' The upper left corner pixel is the raster origin (0,0) with column, row
#' increasing left to right, top to bottom.
#'
#' @param xy Numeric array of geospatial x,y coordinates in the same
#' spatial reference system as \code{gt}. 
#' @param gt Numeric vector of length six. The affine geotransform for the 
#' raster.
#' @returns Integer array of raster pixel/line.
#'
#' @seealso [`GDALRaster$getGeoTransform()`][GDALRaster], [inv_geotransform()]
#'
#' @examples
#' pt_file <- system.file("extdata/storml_pts.csv", package="gdalraster")
#' ## id, x, y in NAD83 / UTM zone 12N
#' pts <- read.csv(pt_file)
#' print(pts)
#' raster_file <- system.file("extdata/storm_lake.lcp", package="gdalraster")
#' ds <- new(GDALRaster, raster_file, read_only=TRUE)
#' gt <- ds$getGeoTransform()
#' get_pixel_line(as.matrix(pts[,-1]), gt)
#' ds$close()
get_pixel_line <- function(xy, gt) {
    .Call(`_gdalraster_get_pixel_line`, xy, gt)
}

#' Build a GDAL virtual raster from a list of datasets
#'
#' `buildVRT()` is a wrapper of the \command{gdalbuildvrt} command-line
#' utility for building a VRT (Virtual Dataset) that is a mosaic of the list
#' of input GDAL datasets
#' (see \url{https://gdal.org/programs/gdalbuildvrt.html}).
#'
#' @details
#' Several command-line options are described in the GDAL documentation at the
#' URL above. By default, the input files are considered as tiles of a larger
#' mosaic and the VRT file has as many bands as one of the input files.
#' Alternatively, the `-separate` argument can be used to put each input
#' raster into a separate band in the VRT dataset.
#'
#' Some amount of checks are done to assure that all files that will be put in
#' the resulting VRT have similar characteristics: number of bands,
#' projection, color interpretation.... If not, files that do not match the
#' common characteristics will be skipped. (This is true in the default
#' mode for virtual mosaicing, and not when using the `-separate` option).
#'
#' In a virtual mosaic, if there is spatial overlap between
#' input rasters then the order of files appearing in the list of
#' sources matter: files that are listed at the end are the ones
#' from which the data will be fetched. Note that nodata will be taken into
#' account to potentially fetch data from less priority datasets.
#'
#' @param vrt_filename Character string. Filename of the output VRT.
#' @param input_rasters Character vector of input raster filenames.
#' @param cl_arg Optional character vector of command-line arguments to 
#' \code{gdalbuildvrt}.
#' @returns Logical indicating success (invisible \code{TRUE}).
#' An error is raised if the operation fails.
#'
#' @seealso
#' [rasterToVRT()]
#'
#' @examples
#' # build a virtual 3-band RGB raster from individual Landsat band files
#' b4_file <- system.file("extdata/sr_b4_20200829.tif", package="gdalraster")
#' b5_file <- system.file("extdata/sr_b5_20200829.tif", package="gdalraster")
#' b6_file <- system.file("extdata/sr_b6_20200829.tif", package="gdalraster")
#' band_files <- c(b6_file, b5_file, b4_file)
#' vrt_file <- paste0(tempdir(), "/", "storml_b6_b5_b4.vrt")
#' buildVRT(vrt_file, band_files, cl_arg = "-separate")
#' ds <- new(GDALRaster, vrt_file, read_only=TRUE)
#' ds$getRasterCount()
#' plot_raster(ds, nbands=3, main="Landsat 6-5-4 (vegetative analysis)")
#' ds$close()
buildVRT <- function(vrt_filename, input_rasters, cl_arg = NULL) {
    invisible(.Call(`_gdalraster_buildVRT`, vrt_filename, input_rasters, cl_arg))
}

#' Raster overlay for unique combinations
#' 
#' @description
#' `combine()` overlays multiple rasters so that a unique ID is assigned to 
#' each unique combination of input values. The input raster layers  
#' typically have integer data types (floating point will be coerced to 
#' integer by truncation), and must have the same projection, extent and cell 
#' size. Pixel counts for each unique combination are obtained, and 
#' combination IDs are optionally written to an output raster.
#'
#' Called from and documented in R/gdalraster_proc.R
#' @noRd
.combine <- function(src_files, var_names, bands, dst_filename = "", fmt = "", dataType = "UInt32", options = NULL) {
    .Call(`_gdalraster__combine`, src_files, var_names, bands, dst_filename, fmt, dataType, options)
}

#' Compute for a raster band the set of unique pixel values and their counts
#' 
#' @noRd
.value_count <- function(src_filename, band = 1L) {
    .Call(`_gdalraster__value_count`, src_filename, band)
}

#' Wrapper for GDALDEMProcessing in the GDAL Algorithms C API
#'
#' Called from and documented in R/gdalraster_proc.R
#' @noRd
.dem_proc <- function(mode, src_filename, dst_filename, cl_arg = NULL, col_file = NULL) {
    .Call(`_gdalraster__dem_proc`, mode, src_filename, dst_filename, cl_arg, col_file)
}

#' Fill selected pixels by interpolation from surrounding areas
#'
#' `fillNodata()` is a wrapper for `GDALFillNodata()` in the GDAL Algorithms
#' API. This algorithm will interpolate values for all designated nodata 
#' pixels (pixels having an intrinsic nodata value, or marked by zero-valued
#' pixels in the optional raster specified in `mask_file`). For each nodata 
#' pixel, a four direction conic search is done to find values to interpolate
#' from (using inverse distance weighting).
#' Once all values are interpolated, zero or more smoothing iterations
#' (3x3 average filters on interpolated pixels) are applied to smooth out 
#' artifacts.
#'
#' @note
#' The input raster will be modified in place. It should not be open in a
#' `GDALRaster` object while processing with `fillNodata()`.
#'
#' @param filename Filename of input raster in which to fill nodata pixels.
#' @param band Integer band number to modify in place.
#' @param mask_file Optional filename of raster to use as a validity mask
#' (band 1 is used, zero marks nodata pixels, non-zero marks valid pixels).
#' @param max_dist Maximum distance (in pixels) that the algorithm 
#' will search out for values to interpolate (100 pixels by default).
#' @param smooth_iterations The number of 3x3 average filter smoothing
#' iterations to run after the interpolation to dampen artifacts
#' (0 by default).
#' @returns Logical indicating success (invisible \code{TRUE}).
#' An error is raised if the operation fails.
#' @examples
#' ## fill nodata edge pixels in the elevation raster
#' elev_file <- system.file("extdata/storml_elev.tif", package="gdalraster")
#' 
#' ## get count of nodata
#' tbl <- buildRAT(elev_file)
#' head(tbl)
#' tbl[is.na(tbl$VALUE),]
#' 
#' ## make a copy that will be modified
#' mod_file <- paste0(tempdir(), "/", "storml_elev_fill.tif")
#' file.copy(elev_file,  mod_file)
#' 
#' fillNodata(mod_file, band=1)
#' 
#' mod_tbl = buildRAT(mod_file)
#' head(mod_tbl)
#' mod_tbl[is.na(mod_tbl$VALUE),]
fillNodata <- function(filename, band, mask_file = "", max_dist = 100, smooth_iterations = 0L) {
    invisible(.Call(`_gdalraster_fillNodata`, filename, band, mask_file, max_dist, smooth_iterations))
}

#' Wrapper for GDALPolygonize in the GDAL Algorithms C API
#'
#' Called from and documented in R/gdalraster_proc.R
#' @noRd
.polygonize <- function(src_filename, src_band, out_dsn, out_layer, fld_name, mask_file = "", nomask = FALSE, connectedness = 4L) {
    .Call(`_gdalraster__polygonize`, src_filename, src_band, out_dsn, out_layer, fld_name, mask_file, nomask, connectedness)
}

#' Wrapper for GDALRasterize in the GDAL Algorithms C API
#'
#' Called from and documented in R/gdalraster_proc.R
#' @noRd
.rasterize <- function(src_dsn, dst_filename, cl_arg) {
    .Call(`_gdalraster__rasterize`, src_dsn, dst_filename, cl_arg)
}

#' Remove small raster polygons
#'
#' `sieveFilter()` is a wrapper for `GDALSieveFilter()` in the GDAL Algorithms
#' API. It removes raster polygons smaller than a provided threshold size
#' (in pixels) and replaces them with the pixel value of the largest neighbour
#' polygon.
#'
#' @details
#' Polygons are determined as regions of the raster where the pixels all have
#' the same value, and that are contiguous (connected).
#' Pixels determined to be "nodata" per the mask band will not be
#' treated as part of a polygon regardless of their pixel values. Nodata areas
#' will never be changed nor affect polygon sizes. Polygons smaller than the
#' threshold with no neighbours that are as large as the threshold will not be
#' altered. Polygons surrounded by nodata areas will therefore not be altered.
#'
#' The algorithm makes three passes over the input file to enumerate the
#' polygons and collect limited information about them. Memory use is
#' proportional to the number of polygons (roughly 24 bytes per polygon), but
#' is not directly related to the size of the raster. So very large raster
#' files can be processed effectively if there aren't too many polygons. But
#' extremely noisy rasters with many one pixel polygons will end up being
#' expensive (in memory) to process.
#'
#' The input dataset is read as integer data which means that floating point
#' values are rounded to integers.
#'
#' @param src_filename Filename of the source raster to be processed.
#' @param src_band Band number in the source raster to be processed.
#' @param dst_filename Filename of the output raster. It may be the same as
#' `src_filename` to update the source file in place.
#' @param dst_band Band number in `dst_filename` to write output. It may be
#' the same as `src_band` to update the source raster in place.
#' @param size_threshold Integer. Raster polygons with sizes (in pixels)
#' smaller than this value will be merged into their largest neighbour.
#' @param connectedness Integer. Either `4` indicating that diagonal pixels
#' are not considered directly adjacent for polygon membership purposes, or
#' `8` indicating they are.
#' @param mask_filename Optional filename of raster to use as a mask.
#' @param mask_band Band number in `mask_filename` to use as a mask. All
#' pixels in the mask band with a value other than zero will be considered
#' suitable for inclusion in polygons.
#' @param options Algorithm options as a character vector of name=value pairs.
#' None currently supported.
#' @returns Logical indicating success (invisible \code{TRUE}).
#' An error is raised if the operation fails.
#'
#' @examples
#' ## remove single-pixel polygons from the vegetation type layer (EVT)
#' evt_file <- system.file("extdata/storml_evt.tif", package="gdalraster")
#'
#' # create a blank raster to hold the output
#' evt_mmu_file <- paste0(tempdir(), "/", "storml_evt_mmu2.tif")
#' rasterFromRaster(srcfile = evt_file,
#'                  dstfile = evt_mmu_file,
#'                  init = 32767)
#'
#' # create a mask to exclude water pixels from the algorithm
#' # recode water (7292) to 0
#' expr <- "ifelse(EVT == 7292, 0, EVT)"
#' mask_file <- calc(expr = expr,
#'                   rasterfiles = evt_file,
#'                   var.names = "EVT")
#'
#' # create a version of EVT with two-pixel minimum mapping unit
#' sieveFilter(src_filename = evt_file,
#'             src_band = 1,
#'             dst_filename = evt_mmu_file,
#'             dst_band = 1,
#'             size_threshold = 2,
#'             connectedness = 8,
#'             mask_filename = mask_file,
#'             mask_band = 1)
sieveFilter <- function(src_filename, src_band, dst_filename, dst_band, size_threshold, connectedness, mask_filename = "", mask_band = 0L, options = NULL) {
    invisible(.Call(`_gdalraster_sieveFilter`, src_filename, src_band, dst_filename, dst_band, size_threshold, connectedness, mask_filename, mask_band, options))
}

#' Convert raster data between different formats
#'
#' `translate()` is a wrapper of the \command{gdal_translate} command-line
#' utility (see \url{https://gdal.org/programs/gdal_translate.html}).
#' The function can be used to convert raster data between different
#' formats, potentially performing some operations like subsetting,
#' resampling, and rescaling pixels in the process. Refer to the GDAL
#' documentation at the URL above for a list of command-line arguments that
#' can be passed in `cl_arg`.
#'
#' @param src_filename Character string. Filename of the source raster.
#' @param dst_filename Character string. Filename of the output raster.
#' @param cl_arg Optional character vector of command-line arguments for 
#' \code{gdal_translate}.
#' @returns Logical indicating success (invisible \code{TRUE}).
#' An error is raised if the operation fails.
#' 
#' @seealso
#' [`GDALRaster-class`][GDALRaster], [rasterFromRaster()], [warp()]
#'
#' @examples
#' # convert the elevation raster to Erdas Imagine format and resample to 90m
#' elev_file <- system.file("extdata/storml_elev.tif", package="gdalraster")
#'
#' # command-line arguments for gdal_translate
#' args <- c("-tr", "90", "90", "-r", "average")
#' args <- c(args, "-of", "HFA", "-co", "COMPRESSED=YES")
#'
#' img_file <- paste0(tempdir(), "/", "storml_elev_90m.img")
#' translate(elev_file, img_file, args)
#' 
#' ds <- new(GDALRaster, img_file, read_only=TRUE)
#' ds$getDriverLongName()
#' ds$bbox()
#' ds$res()
#' ds$getStatistics(band=1, approx_ok=FALSE, force=TRUE)
#' ds$close()
translate <- function(src_filename, dst_filename, cl_arg = NULL) {
    invisible(.Call(`_gdalraster_translate`, src_filename, dst_filename, cl_arg))
}

#' Raster reprojection and mosaicing
#'
#' `warp()` is a wrapper of the \command{gdalwarp} command-line utility for
#' raster mosaicing, reprojection and warping
#' (see \url{https://gdal.org/programs/gdalwarp.html}).
#' The function can reproject to any supported spatial reference system (SRS).
#' It can also be used to crop, resample, and optionally write output to a
#' different raster format. See Details for a list of commonly used
#' processing options that can be passed as arguments to `warp()`.
#'
#' @details
#' Several processing options can be performed in one call to `warp()` by
#' passing the necessary command-line arguments. The following list describes
#' several commonly used arguments. Note that `gdalwarp` supports a large
#' number of arguments that enable a variety of different processing options.
#' Users are encouraged to review the original source documentation provided
#' by the GDAL project at the URL above for the full list.
#'
#'   * `-te <xmin> <ymin> <xmax> <ymax>`\cr
#'   Georeferenced extents of output file to be created (in target SRS by
#'   default).
#'   * `-te_srs <srs_def>`\cr
#'   SRS in which to interpret the coordinates given with `-te`
#'   (if different than `t_srs`).
#'   * `-tr <xres> <yres>`\cr
#'   Output pixel resolution (in target georeferenced units).
#'   * `-tap`\cr
#'   (target aligned pixels) align the coordinates of the extent of the output
#'   file to the values of the `-tr`, such that the aligned extent includes
#'   the minimum extent. Alignment means that xmin / resx, ymin / resy,
#'   xmax / resx and ymax / resy are integer values.
#'   * `-ovr <level>|AUTO|AUTO-<n>|NONE`\cr
#'   Specify which overview level of source files must be used. The default
#'   choice, `AUTO`, will select the overview level whose resolution is the
#'   closest to the target resolution. Specify an integer value (0-based,
#'   i.e., 0=1st overview level) to select a particular level. Specify
#'   `AUTO-n` where `n` is an integer greater or equal to `1`, to select an
#'   overview level below the `AUTO` one. Or specify `NONE` to force the base
#'   resolution to be used (can be useful if overviews have been generated
#'   with a low quality resampling method, and the warping is done using a
#'   higher quality resampling method).
#'   * `-wo <NAME>=<VALUE>`\cr
#'   Set a warp option as described in the GDAL documentation for
#'   [`GDALWarpOptions`](https://gdal.org/api/gdalwarp_cpp.html#_CPPv415GDALWarpOptions)
#'   Multiple `-wo` may be given. See also `-multi` below.
#'   * `-ot <type>`\cr
#'   Force the output raster bands to have a specific data type supported by
#'   the format, which may be one of the following: `Byte`, `Int8`, `UInt16`,
#'   `Int16`, `UInt32`, `Int32`, `UInt64`, `Int64`, `Float32`, `Float64`,
#'   `CInt16`, `CInt32`, `CFloat32` or `CFloat64`.
#'   * `-r <resampling_method>`\cr
#'   Resampling method to use. Available methods are: `near` (nearest
#'   neighbour, the default), `bilinear`, `cubic`, `cubicspline`, `lanczos`,
#'   `average`, `rms` (root mean square, GDAL >= 3.3), `mode`, `max`, `min`,
#'   `med`, `q1` (first quartile), `q3` (third quartile), `sum` (GDAL >= 3.1).
#'   * `-srcnodata "<value>[ <value>]..."`\cr
#'   Set nodata masking values for input bands (different values can be
#'   supplied for each band). If more than one value is supplied all values
#'   should be quoted to keep them together as a single operating system
#'   argument. Masked values will not be used in interpolation. Use a value of
#'   `None` to ignore intrinsic nodata settings on the source dataset.
#'   If `-srcnodata` is not explicitly set, but the source dataset has nodata
#'   values, they will be taken into account by default.
#'   * `-dstnodata "<value>[ <value>]..."`\cr
#'   Set nodata values for output bands (different values can be supplied for
#'   each band). If more than one value is supplied all values should be
#'   quoted to keep them together as a single operating system argument. New
#'   files will be initialized to this value and if possible the nodata value
#'   will be recorded in the output file. Use a value of `"None"` to ensure
#'   that nodata is not defined. If this argument is not used then nodata
#'   values will be copied from the source dataset.
#'   * `-wm <memory_in_mb>`\cr
#'   Set the amount of memory that the warp API is allowed to use for caching.
#'   The value is interpreted as being in megabytes if the value is <10000.
#'   For values >=10000, this is interpreted as bytes. The warper will
#'   total up the memory required to hold the input and output image arrays
#'   and any auxiliary masking arrays and if they are larger than the
#'   "warp memory" allowed it will subdivide the chunk into smaller chunks and
#'   try again. If the `-wm` value is very small there is some extra overhead
#'   in doing many small chunks so setting it larger is better but it is a
#'   matter of diminishing returns.
#'   * `-multi`\cr
#'   Use multithreaded warping implementation. Two threads will be used to
#'   process chunks of image and perform input/output operation
#'   simultaneously. Note that computation is not multithreaded itself. To do
#'   that, you can use the `-wo NUM_THREADS=val/ALL_CPUS` option, which can be
#'   combined with `-multi`.
#'   * `-of <format>`
#'   Set the output raster format. Will be guessed from the extension if not
#'   specified. Use the short format name (e.g., `"GTiff"`).
#'   * `-co <NAME>=<VALUE>`\cr
#'   Set one or more format specific creation options for the output dataset.
#'   For example, the GeoTIFF driver supports creation options to control
#'   compression, and whether the file should be tiled.
#'   [getCreationOptions()] can be used to look up available creation options,
#'   but the GDAL [Raster drivers](https://gdal.org/drivers/raster/index.html)
#'   documentation is the definitive reference for format specific options.
#'   Multiple `-co` may be given, e.g.,
#'   \preformatted{ c("-co", "COMPRESS=LZW", "-co", "BIGTIFF=YES") }
#'   * `-overwrite`\cr
#'   Overwrite the target dataset if it already exists. Overwriting means
#'   deleting and recreating the file from scratch. Note that if this option
#'   is not specified and the output file already exists, it will be updated
#'   in place.
#'
#' The documentation for [`gdalwarp`](https://gdal.org/programs/gdalwarp.html)
#' describes additional command-line options related to spatial reference
#' systems, source nodata values, alpha bands, polygon cutlines as mask
#' including blending, and more.
#'
#' Mosaicing into an existing output file is supported if the output file
#' already exists. The spatial extent of the existing file will not be
#' modified to accommodate new data, so you may have to remove it in that
#' case, or use the `-overwrite` option.
#'
#' Command-line options are passed to `warp()` as a character vector. The
#' elements of the vector are the individual options followed by their
#' individual values, e.g.,
#' \preformatted{
#' cl_arg = c("-tr", "30", "30", "-r", "bilinear"))
#' }
#' to set the target pixel resolution to 30 x 30 in target georeferenced
#' units and use bilinear resampling.
#' 
#' @param src_files Character vector of source file(s) to be reprojected.
#' @param dst_filename Character string. Filename of the output raster.
#' @param t_srs Character string. Target spatial reference system. Usually an 
#' EPSG code ("EPSG:#####") or a well known text (WKT) SRS definition.
#' If empty string `""`, the spatial reference of `src_files[1]` will be
#' used (see Note).
#' @param cl_arg Optional character vector of command-line arguments to 
#' \code{gdalwarp} in addition to `-t_srs` (see Details).
#' @returns Logical indicating success (invisible \code{TRUE}).
#' An error is raised if the operation fails.
#'
#' @note
#' `warp()` can be used to reproject and also perform other processing such
#' as crop, resample, and mosaic.
#' This processing is generally done with a single function call by passing
#' arguments for the target (output) pixel resolution, extent, resampling
#' method, nodata value, format, and so forth.
#' If `warp()` is called with `t_srs` set to `""` (empty string),
#' the target spatial reference will be set to that of `src_files[1]`,
#' so that the processing options given in `cl_arg` will be performed without
#' reprojecting (in the case of one input raster or multiple inputs that
#' all use the same spatial reference system, otherwise would reproject
#' inputs to the SRS of `src_files[1]` when they are different).
#'
#' @seealso
#' [`GDALRaster-class`][GDALRaster], [srs_to_wkt()], [translate()]
#'
#' @examples
#' # reproject the elevation raster to NAD83 / CONUS Albers (EPSG:5070)
#' elev_file <- system.file("extdata/storml_elev.tif", package="gdalraster")
#'
#' # command-line arguments for gdalwarp
#' # resample to 90-m resolution and keep pixels aligned:
#' args <- c("-tr", "90", "90", "-r", "cubic", "-tap")
#' # write to Erdas Imagine format (HFA) with compression:
#' args <- c(args, "-of", "HFA", "-co", "COMPRESSED=YES")
#'
#' alb83_file <- paste0(tempdir(), "/", "storml_elev_alb83.img")
#' warp(elev_file, alb83_file, t_srs="EPSG:5070", cl_arg = args)
#' 
#' ds <- new(GDALRaster, alb83_file, read_only=TRUE)
#' ds$getDriverLongName()
#' ds$getProjectionRef()
#' ds$res()
#' ds$getStatistics(band=1, approx_ok=FALSE, force=TRUE)
#' ds$close()
warp <- function(src_files, dst_filename, t_srs, cl_arg = NULL) {
    invisible(.Call(`_gdalraster_warp`, src_files, dst_filename, t_srs, cl_arg))
}

#' Create a color ramp
#'
#' `createColorRamp()` is a wrapper for `GDALCreateColorRamp()` in the GDAL
#' API. It automatically creates a color ramp from one color entry to another.
#' Output is an integer matrix in color table format for use with
#' [`GDALRaster$setColorTable()`][GDALRaster].
#'
#' @note
#' `createColorRamp()` could be called several times, using `rbind()` to
#' combine multiple ramps into the same color table. Possible duplicate rows
#' in the resulting table are not a problem when used in
#' `GDALRaster$setColorTable()` (i.e., when `end_color` of one ramp is the
#' same as `start_color` of the next ramp).
#'
#' @param start_index Integer start index (raster value).
#' @param start_color Integer vector of length three or four.
#' A color entry value to start the ramp (e.g., RGB values).
#' @param end_index Integer end index (raster value).
#' @param end_color Integer vector of length three or four.
#' A color entry value to end the ramp (e.g., RGB values).
#' @param palette_interp One of "Gray", "RGB" (the default), "CMYK" or "HLS"
#' describing interpretation of `start_color` and `end_color` values
#' (see \href{https://gdal.org/user/raster_data_model.html#color-table}{GDAL 
#' Color Table}).
#' @returns Integer matrix with five columns containing the color ramp from
#' `start_index` to `end_index`, with raster index values in column 1 and
#' color entries in columns 2:5).
#'
#' @seealso
#' [`GDALRaster$getColorTable()`][GDALRaster],
#' [`GDALRaster$getPaletteInterp()`][GDALRaster]
#'
#' @examples
#' # create a color ramp for tree canopy cover percent
#' # band 5 of an LCP file contains canopy cover
#' lcp_file <- system.file("extdata/storm_lake.lcp", package="gdalraster")
#' ds <- new(GDALRaster, lcp_file, read_only=TRUE)
#' ds$getDescription(band=5)
#' ds$getMetadata(band=5, domain="")
#' ds$close()
#'
#' # create a GTiff file with Byte data type for the canopy cover band
#' # recode nodata -9999 to 255
#' tcc_file <- calc(expr = "ifelse(CANCOV == -9999, 255, CANCOV)",
#'                  rasterfiles = lcp_file,
#'                  bands = 5,
#'                  var.names = "CANCOV",
#'                  fmt = "GTiff",
#'                  dtName = "Byte",
#'                  nodata_value = 255,
#'                  setRasterNodataValue = TRUE)
#' 
#' ds_tcc <- new(GDALRaster, tcc_file, read_only=FALSE)
#' 
#' # create a color ramp from 0 to 100 and set as the color table
#' colors <- createColorRamp(start_index = 0,
#'                           start_color = c(211, 211, 211),
#'                           end_index = 100,
#'                           end_color = c(0, 100, 0))
#' 
#' print(colors)
#' ds_tcc$setColorTable(band=1, col_tbl=colors, palette_interp="RGB")
#' ds_tcc$setRasterColorInterp(band=1, col_interp="Palette")
#' 
#' # close and re-open the dataset in read_only mode
#' ds_tcc$open(read_only=TRUE)
#' 
#' plot_raster(ds_tcc, interpolate=FALSE, legend=TRUE,
#'             main="Storm Lake Tree Canopy Cover (%)")
#' ds_tcc$close()
createColorRamp <- function(start_index, start_color, end_index, end_color, palette_interp = "RGB") {
    .Call(`_gdalraster_createColorRamp`, start_index, start_color, end_index, end_color, palette_interp)
}

#' Copy a whole raster band efficiently
#'
#' `bandCopyWholeRaster()` copies the complete raster contents of one band to
#' another similarly configured band. The source and destination bands must
#' have the same xsize and ysize. The bands do not have to have the same data
#' type. It implements efficient copying, in particular "chunking" the copy in
#' substantial blocks. This is a wrapper for `GDALRasterBandCopyWholeRaster()`
#' in the GDAL API.
#'
#' @param src_filename Filename of the source raster.
#' @param src_band Band number in the source raster to be copied.
#' @param dst_filename Filename of the destination raster.
#' @param dst_band Band number in the destination raster to copy into.
#' @param options Optional list of transfer hints in a vector of `"NAME=VALUE"`
#' pairs. The currently supported `options` are:
#'   * `"COMPRESSED=YES"` to force alignment on target dataset block sizes to
#'   achieve best compression. 
#'    * `"SKIP_HOLES=YES"` to skip chunks that contain only empty blocks.
#'    Empty blocks are blocks that are generally not physically present in the
#'    file, and when read through GDAL, contain only pixels whose value is the
#'    nodata value when it is set, or whose value is 0 when the nodata value is
#'    not set. The query is done in an efficient way without reading the actual
#'    pixel values (if implemented by the raster format driver, otherwise will
#'    not be skipped).
#' @returns Logical indicating success (invisible \code{TRUE}).
#' An error is raised if the operation fails.
#'
#' @seealso
#' [`GDALRaster-class`][GDALRaster], [create()], [createCopy()],
#' [rasterFromRaster()]
#'
#' @examples
#' ## copy Landsat data from a single-band file to a new multi-band image
#' b5_file <- system.file("extdata/sr_b5_20200829.tif", package="gdalraster")
#' dst_file <- paste0(tempdir(), "/", "sr_multi.tif")
#' rasterFromRaster(b5_file, dst_file, nbands=7, init=0)
#' opt <- c("COMPRESSED=YES", "SKIP_HOLES=YES")
#' bandCopyWholeRaster(b5_file, 1, dst_file, 5, options=opt)
#' ds <- new(GDALRaster, dst_file, read_only=TRUE)
#' ds$getStatistics(band=5, approx_ok=FALSE, force=TRUE)
#' ds$close()
bandCopyWholeRaster <- function(src_filename, src_band, dst_filename, dst_band, options = NULL) {
    invisible(.Call(`_gdalraster_bandCopyWholeRaster`, src_filename, src_band, dst_filename, dst_band, options))
}

#' Delete named dataset
#'
#' `deleteDataset()` will attempt to delete the named dataset in a format
#' specific fashion. Full featured drivers will delete all associated files,
#' database objects, or whatever is appropriate. The default behavior when no
#' format specific behavior is provided is to attempt to delete all the files
#' that would be returned by `GDALRaster$getFileList()` on the dataset.
#' The named dataset should not be open in any existing `GDALRaster` objects
#' when `deleteDataset()` is called. Wrapper for `GDALDeleteDataset()` in the
#' GDAL API.
#'
#' @note
#' If `format` is set to an empty string `""` (the default) then the function
#' will try to identify the driver from `filename`. This is done internally in
#' GDAL by invoking the `Identify` method of each registered `GDALDriver` in
#' turn. The first driver that successful identifies the file name will be
#' returned. An error is raised if a format cannot be determined from the
#' passed file name.
#'
#' @param filename Filename to delete (should not be open in a `GDALRaster`
#' object).
#' @param format Raster format short name (e.g., "GTiff"). If set to empty
#' string `""` (the default), will attempt to guess the raster format from
#' `filename`.
#' @returns Logical `TRUE` if no error or `FALSE` on failure.
#'
#' @seealso
#' [`GDALRaster-class`][GDALRaster], [create()], [createCopy()],
#' [copyDatasetFiles()], [renameDataset()]
#'
#' @examples
#' b5_file <- system.file("extdata/sr_b5_20200829.tif", package="gdalraster")
#' b5_tmp <- paste0(tempdir(), "/", "b5_tmp.tif")
#' file.copy(b5_file,  b5_tmp)
#' 
#' ds <- new(GDALRaster, b5_tmp, read_only=TRUE)
#' ds$buildOverviews("BILINEAR", levels = c(2, 4, 8), bands = c(1))
#' files <- ds$getFileList()
#' print(files)
#' ds$close()
#' file.exists(files)
#' deleteDataset(b5_tmp)
#' file.exists(files)
deleteDataset <- function(filename, format = "") {
    .Call(`_gdalraster_deleteDataset`, filename, format)
}

#' Rename a dataset
#'
#' `renameDataset()` renames a dataset in a format-specific way (e.g.,
#' rename associated files as appropriate). This could include moving the
#' dataset to a new directory or even a new filesystem.
#' The dataset should not be open in any existing `GDALRaster` objects
#' when `renameDataset()` is called. Wrapper for `GDALRenameDataset()` in the
#' GDAL API.
#'
#' @note
#' If `format` is set to an empty string `""` (the default) then the function
#' will try to identify the driver from `old_filename`. This is done
#' internally in GDAL by invoking the `Identify` method of each registered
#' `GDALDriver` in turn. The first driver that successful identifies the file
#' name will be returned. An error is raised if a format cannot be determined
#' from the passed file name.
#'
#' @param new_filename New name for the dataset.
#' @param old_filename Old name for the dataset (should not be open in a
#' `GDALRaster` object).
#' @param format Raster format short name (e.g., "GTiff"). If set to empty
#' string `""` (the default), will attempt to guess the raster format from
#' `old_filename`.
#' @returns Logical `TRUE` if no error or `FALSE` on failure.
#'
#' @seealso
#' [`GDALRaster-class`][GDALRaster], [create()], [createCopy()],
#' [deleteDataset()], [copyDatasetFiles()]
#'
#' @examples
#' b5_file <- system.file("extdata/sr_b5_20200829.tif", package="gdalraster")
#' b5_tmp <- paste0(tempdir(), "/", "b5_tmp.tif")
#' file.copy(b5_file,  b5_tmp)
#' 
#' ds <- new(GDALRaster, b5_tmp, read_only=TRUE)
#' ds$buildOverviews("BILINEAR", levels = c(2, 4, 8), bands = c(1))
#' ds$getFileList()
#' ds$close()
#' b5_tmp2 <- paste0(tempdir(), "/", "b5_tmp_renamed.tif")
#' renameDataset(b5_tmp2, b5_tmp)
#' ds <- new(GDALRaster, b5_tmp2, read_only=TRUE)
#' ds$getFileList()
#' ds$close()
renameDataset <- function(new_filename, old_filename, format = "") {
    .Call(`_gdalraster_renameDataset`, new_filename, old_filename, format)
}

#' Copy the files of a dataset
#'
#' `copyDatasetFiles()` copies all the files associated with a dataset.
#' Wrapper for `GDALCopyDatasetFiles()` in the GDAL API.
#'
#' @note
#' If `format` is set to an empty string `""` (the default) then the function
#' will try to identify the driver from `old_filename`. This is done
#' internally in GDAL by invoking the `Identify` method of each registered
#' `GDALDriver` in turn. The first driver that successful identifies the file
#' name will be returned. An error is raised if a format cannot be determined
#' from the passed file name.
#'
#' @param new_filename New name for the dataset (copied to).
#' @param old_filename Old name for the dataset (copied from).
#' @param format Raster format short name (e.g., "GTiff"). If set to empty
#' string `""` (the default), will attempt to guess the raster format from
#' `old_filename`.
#' @returns Logical `TRUE` if no error or `FALSE` on failure.
#'
#' @seealso
#' [`GDALRaster-class`][GDALRaster], [create()], [createCopy()],
#' [deleteDataset()], [renameDataset()]
#'
#' @examples
#' lcp_file <- system.file("extdata/storm_lake.lcp", package="gdalraster")
#' ds <- new(GDALRaster, lcp_file, read_only=TRUE)
#' ds$getFileList()
#' ds$close()
#' 
#' lcp_tmp <- paste0(tempdir(), "/", "storm_lake_copy.lcp")
#' copyDatasetFiles(lcp_tmp, lcp_file)
#' ds_copy <- new(GDALRaster, lcp_tmp, read_only=TRUE)
#' ds_copy$getFileList()
#' ds_copy$close()
copyDatasetFiles <- function(new_filename, old_filename, format = "") {
    .Call(`_gdalraster_copyDatasetFiles`, new_filename, old_filename, format)
}

#' Return the list of creation options of a GDAL driver as XML string
#'
#' Called from and documented in R/gdal_helpers.R
#' @noRd
.getCreationOptions <- function(format) {
    .Call(`_gdalraster__getCreationOptions`, format)
}

#' @noRd
NULL

#' @noRd
NULL

#' @noRd
NULL

#' @noRd
NULL

#' Is GEOS available?
#'
#' `has_geos()` returns a logical value indicating whether GDAL was built
#' against the GEOS library.
#'
#' @return Logical. `TRUE` if GEOS is available, otherwise `FALSE`.
#'
#' @examples
#' has_geos()
has_geos <- function() {
    .Call(`_gdalraster_has_geos`)
}

#' @noRd
.g_create <- function(xy, geom_type) {
    .Call(`_gdalraster__g_create`, xy, geom_type)
}

#' @noRd
.g_is_valid <- function(geom) {
    .Call(`_gdalraster__g_is_valid`, geom)
}

#' @noRd
.g_intersects <- function(this_geom, other_geom) {
    .Call(`_gdalraster__g_intersects`, this_geom, other_geom)
}

#' @noRd
.g_equals <- function(this_geom, other_geom) {
    .Call(`_gdalraster__g_equals`, this_geom, other_geom)
}

#' @noRd
.g_disjoint <- function(this_geom, other_geom) {
    .Call(`_gdalraster__g_disjoint`, this_geom, other_geom)
}

#' @noRd
.g_touches <- function(this_geom, other_geom) {
    .Call(`_gdalraster__g_touches`, this_geom, other_geom)
}

#' @noRd
.g_contains <- function(this_geom, other_geom) {
    .Call(`_gdalraster__g_contains`, this_geom, other_geom)
}

#' @noRd
.g_within <- function(this_geom, other_geom) {
    .Call(`_gdalraster__g_within`, this_geom, other_geom)
}

#' @noRd
.g_crosses <- function(this_geom, other_geom) {
    .Call(`_gdalraster__g_crosses`, this_geom, other_geom)
}

#' @noRd
.g_overlaps <- function(this_geom, other_geom) {
    .Call(`_gdalraster__g_overlaps`, this_geom, other_geom)
}

#' @noRd
.g_buffer <- function(geom, dist, quad_segs = 30L) {
    .Call(`_gdalraster__g_buffer`, geom, dist, quad_segs)
}

#' @noRd
.g_intersection <- function(this_geom, other_geom) {
    .Call(`_gdalraster__g_intersection`, this_geom, other_geom)
}

#' @noRd
.g_union <- function(this_geom, other_geom) {
    .Call(`_gdalraster__g_union`, this_geom, other_geom)
}

#' @noRd
.g_difference <- function(this_geom, other_geom) {
    .Call(`_gdalraster__g_difference`, this_geom, other_geom)
}

#' @noRd
.g_sym_difference <- function(this_geom, other_geom) {
    .Call(`_gdalraster__g_sym_difference`, this_geom, other_geom)
}

#' @noRd
.g_distance <- function(this_geom, other_geom) {
    .Call(`_gdalraster__g_distance`, this_geom, other_geom)
}

#' @noRd
.g_length <- function(geom) {
    .Call(`_gdalraster__g_length`, geom)
}

#' @noRd
.g_area <- function(geom) {
    .Call(`_gdalraster__g_area`, geom)
}

#' @noRd
.g_centroid <- function(geom) {
    .Call(`_gdalraster__g_centroid`, geom)
}

#' Does vector dataset exist
#' 
#' @noRd
.ogr_ds_exists <- function(dsn, with_update = FALSE) {
    .Call(`_gdalraster__ogr_ds_exists`, dsn, with_update)
}

#' Create a vector dataset with layer and field
#' currently hard coded as layer of wkbPolygon, field of OFTInteger
#'
#' @noRd
.create_ogr <- function(format, dst_filename, xsize, ysize, nbands, dataType, layer, srs = "", fld_name = "", dsco = NULL, lco = NULL) {
    .Call(`_gdalraster__create_ogr`, format, dst_filename, xsize, ysize, nbands, dataType, layer, srs, fld_name, dsco, lco)
}

#' Get number of layers in a dataset
#' 
#' @noRd
.ogr_ds_layer_count <- function(dsn) {
    .Call(`_gdalraster__ogr_ds_layer_count`, dsn)
}

#' Does layer exist
#' 
#' @noRd
.ogr_layer_exists <- function(dsn, layer) {
    .Call(`_gdalraster__ogr_layer_exists`, dsn, layer)
}

#' Create a layer in a vector dataset
#' currently hard coded as layer of wkbPolygon
#'
#' @noRd
.ogr_layer_create <- function(dsn, layer, srs = "", options = NULL) {
    .Call(`_gdalraster__ogr_layer_create`, dsn, layer, srs, options)
}

#' Delete a layer in a vector dataset
#'
#' @noRd
.ogr_layer_delete <- function(dsn, layer) {
    .Call(`_gdalraster__ogr_layer_delete`, dsn, layer)
}

#' Get field index or -1 if fld_name not found
#' 
#' @noRd
.ogr_field_index <- function(dsn, layer, fld_name) {
    .Call(`_gdalraster__ogr_field_index`, dsn, layer, fld_name)
}

#' Create a new field on layer
#' currently hard coded for OFTInteger
#'
#' @noRd
.ogr_field_create <- function(dsn, layer, fld_name) {
    .Call(`_gdalraster__ogr_field_create`, dsn, layer, fld_name)
}

#' get PROJ version
#' @noRd
.getPROJVersion <- function() {
    .Call(`_gdalraster__getPROJVersion`)
}

#' get search path(s) for PROJ resource files
#' @noRd
.getPROJSearchPaths <- function() {
    .Call(`_gdalraster__getPROJSearchPaths`)
}

#' set search path(s) for PROJ resource files
#' @noRd
.setPROJSearchPaths <- function(paths) {
    invisible(.Call(`_gdalraster__setPROJSearchPaths`, paths))
}

#' get whether PROJ networking capabilities are enabled
#' returns logical NA if GDAL < 3.4
#' @noRd
.getPROJEnableNetwork <- function() {
    .Call(`_gdalraster__getPROJEnableNetwork`)
}

#' enable or disable PROJ networking capabilities
#' @noRd
.setPROJEnableNetwork <- function(enabled) {
    invisible(.Call(`_gdalraster__setPROJEnableNetwork`, enabled))
}

#' Inverse project geospatial x/y coordinates to longitude/latitude
#'
#' `inv_project()` transforms geospatial x/y coordinates to
#' longitude/latitude in the same geographic coordinate system used by the
#' given projected spatial reference system. The output long/lat can
#' optionally be set to a specific geographic coordinate system by specifying
#' a well known name (see Details).
#'
#' @details
#' By default, the geographic coordinate system of the projection specified
#' by `srs` will be used. If a specific geographic coordinate system is
#' desired, then `well_known_gcs` can be set to one of the values below:
#' \tabular{rl}{
#'  EPSG:n \tab where n is the code of a geographic coordinate system\cr
#'  WGS84  \tab same as EPSG:4326\cr
#'  WGS72  \tab same as EPSG:4322\cr
#'  NAD83  \tab same as EPSG:4269\cr
#'  NAD27  \tab same as EPSG:4267\cr
#'  CRS84  \tab same as WGS84\cr
#'  CRS72  \tab same as WGS72\cr
#'  CRS27  \tab same as NAD27
#' }
#' The returned array will always be in longitude, latitude order
#' (traditional GIS order) regardless of the axis order defined for the
#' names above.
#'
#' @param pts A two-column data frame or numeric matrix containing geospatial
#' x/y coordinates.
#' @param srs Character string in OGC WKT format specifying the projected 
#' spatial reference system for `pts`.
#' @param well_known_gcs Optional character string containing a supported 
#' well known name of a geographic coordinate system (see Details for 
#' supported values).
#' @returns Numeric array of longitude, latitude. An error is raised if the 
#' transformation cannot be performed.
#' @seealso
#' [transform_xy()]
#' @examples
#' pt_file <- system.file("extdata/storml_pts.csv", package="gdalraster")
#' ## id, x, y in NAD83 / UTM zone 12N
#' pts <- read.csv(pt_file)
#' print(pts)
#' inv_project(pts[,-1], epsg_to_wkt(26912))
#' inv_project(pts[,-1], epsg_to_wkt(26912), "NAD27")
inv_project <- function(pts, srs, well_known_gcs = "") {
    .Call(`_gdalraster_inv_project`, pts, srs, well_known_gcs)
}

#' Transform geospatial x/y coordinates
#'
#' `transform_xy()` transforms geospatial x/y coordinates to a new projection.
#'
#' @param pts A two-column data frame or numeric matrix containing geospatial
#' x/y coordinates.
#' @param srs_from Character string in OGC WKT format specifying the  
#' spatial reference system for `pts`.
#' @param srs_to Character string in OGC WKT format specifying the output 
#' spatial reference system.
#' @returns Numeric array of geospatial x/y coordinates in the projection 
#' specified by `srs_to`.
#'
#' @seealso
#' [epsg_to_wkt()], [srs_to_wkt()], [inv_project()]
#' @examples
#' pt_file <- system.file("extdata/storml_pts.csv", package="gdalraster")
#' pts <- read.csv(pt_file)
#' print(pts)
#' ## id, x, y in NAD83 / UTM zone 12N
#' ## transform to NAD83 / CONUS Albers
#' transform_xy(pts = pts[,-1], 
#'              srs_from = epsg_to_wkt(26912), 
#'              srs_to = epsg_to_wkt(5070))
transform_xy <- function(pts, srs_from, srs_to) {
    .Call(`_gdalraster_transform_xy`, pts, srs_from, srs_to)
}

#' Convert spatial reference from EPSG code to OGC Well Known Text
#'
#' `epsg_to_wkt()` exports the spatial reference for an EPSG code to 
#' WKT format.
#'
#' @details
#' As of GDAL 3.0, the default format for WKT export is OGC WKT 1.
#' The WKT version can be overridden by using the OSR_WKT_FORMAT 
#' configuration option (see [set_config_option()]).
#' Valid values are one of: SFSQL, WKT1_SIMPLE, WKT1, WKT1_GDAL, 
#' WKT1_ESRI, WKT2_2015, WKT2_2018, WKT2, DEFAULT.
#' If SFSQL, a WKT1 string without AXIS, TOWGS84, AUTHORITY or 
#' EXTENSION node is returned. If WKT1_SIMPLE, a WKT1 string without 
#' AXIS, AUTHORITY or EXTENSION node is returned. WKT1 is an alias of 
#' WKT1_GDAL. WKT2 will default to the latest revision implemented 
#' (currently WKT2_2018). WKT2_2019 can be used as an alias of 
#' WKT2_2018 since GDAL 3.2
#'
#' @param epsg Integer EPSG code.
#' @param pretty Logical. `TRUE` to return a nicely formatted WKT string 
#' for display to a person. `FALSE` for a regular WKT string (the default).
#' @return Character string containing OGC WKT.
#'
#' @seealso
#' [srs_to_wkt()]
#'
#' @examples
#' epsg_to_wkt(5070)
#' writeLines(epsg_to_wkt(5070, pretty=TRUE))
#' set_config_option("OSR_WKT_FORMAT", "WKT2")
#' writeLines(epsg_to_wkt(5070, pretty=TRUE))
#' set_config_option("OSR_WKT_FORMAT", "")
epsg_to_wkt <- function(epsg, pretty = FALSE) {
    .Call(`_gdalraster_epsg_to_wkt`, epsg, pretty)
}

#' Convert spatial reference definition to OGC Well Known Text
#'
#' `srs_to_wkt()` converts a spatial reference system (SRS) definition 
#' in various text formats to WKT. The function will examine the input SRS, 
#' try to deduce the format, and then export it to WKT.
#'
#' @details
#' This is a wrapper for `OSRSetFromUserInput()` in the GDAL Spatial 
#' Reference System C API with output to WKT. 
#' The input SRS may take the following forms:
#'   * WKT - to convert WKT versions (see below)
#'   * EPSG:n - EPSG code n
#'   * AUTO:proj_id,unit_id,lon0,lat0 - WMS auto projections
#'   * urn:ogc:def:crs:EPSG::n - OGC URNs
#'   * PROJ.4 definitions
#'   * filename - file to read for WKT, XML or PROJ.4 definition
#'   * well known name such as NAD27, NAD83, WGS84 or WGS72
#'   * IGNF:xxxx, ESRI:xxxx - definitions from the PROJ database
#'   * PROJJSON (PROJ >= 6.2)
#'
#' This function is intended to be flexible, but by its nature it is 
#' imprecise as it must guess information about the format intended. 
#' [epsg_to_wkt()] could be used instead for EPSG codes.
#'
#' As of GDAL 3.0, the default format for WKT export is OGC WKT 1.
#' The WKT version can be overridden by using the OSR_WKT_FORMAT 
#' configuration option (see [set_config_option()]).
#' Valid values are one of: SFSQL, WKT1_SIMPLE, WKT1, WKT1_GDAL, 
#' WKT1_ESRI, WKT2_2015, WKT2_2018, WKT2, DEFAULT.
#' If SFSQL, a WKT1 string without AXIS, TOWGS84, AUTHORITY or 
#' EXTENSION node is returned. If WKT1_SIMPLE, a WKT1 string without 
#' AXIS, AUTHORITY or EXTENSION node is returned. WKT1 is an alias of 
#' WKT1_GDAL. WKT2 will default to the latest revision implemented 
#' (currently WKT2_2018). WKT2_2019 can be used as an alias of 
#' WKT2_2018 since GDAL 3.2
#'
#' @param srs Character string containing an SRS definition in various
#' formats (see Details).
#' @param pretty Logical. `TRUE` to return a nicely formatted WKT string 
#' for display to a person. `FALSE` for a regular WKT string (the default).
#' @return Character string containing OGC WKT.
#'
#' @seealso
#' [epsg_to_wkt()]
#'
#' @examples
#' srs_to_wkt("NAD83")
#' writeLines(srs_to_wkt("NAD83", pretty=TRUE))
#' set_config_option("OSR_WKT_FORMAT", "WKT2")
#' writeLines(srs_to_wkt("NAD83", pretty=TRUE))
#' set_config_option("OSR_WKT_FORMAT", "")
srs_to_wkt <- function(srs, pretty = FALSE) {
    .Call(`_gdalraster_srs_to_wkt`, srs, pretty)
}

#' Check if WKT definition is a geographic coordinate system
#'
#' `srs_is_geographic()` will attempt to import the given WKT string as a 
#' spatial reference system, and returns `TRUE`  if the root is a 
#' GEOGCS node. This is a wrapper for `OSRIsGeographic()` in the GDAL Spatial 
#' Reference System C API.
#'
#' @param srs Character OGC WKT string for a spatial reference system
#' @return Logical. `TRUE` if `srs` is geographic, otherwise `FALSE`
#'
#' @seealso
#' [srs_is_projected()], [srs_is_same()]
#'
#' @examples
#' srs_is_geographic(epsg_to_wkt(5070))
#' srs_is_geographic(srs_to_wkt("WGS84"))
srs_is_geographic <- function(srs) {
    .Call(`_gdalraster_srs_is_geographic`, srs)
}

#' Check if WKT definition is a projected coordinate system
#'
#' `srs_is_projected()` will attempt to import the given WKT string as a 
#' spatial reference system (SRS), and returns `TRUE` if the SRS contains a 
#' PROJCS node indicating a it is a projected coordinate system. This is a 
#' wrapper for `OSRIsProjected()` in the GDAL Spatial Reference System C API.
#'
#' @param srs Character OGC WKT string for a spatial reference system
#' @return Logical. `TRUE` if `srs` is projected, otherwise `FALSE`
#'
#' @seealso
#' [srs_is_geographic()], [srs_is_same()]
#'
#' @examples
#' srs_is_projected(epsg_to_wkt(5070))
#' srs_is_projected(srs_to_wkt("WGS84"))
srs_is_projected <- function(srs) {
    .Call(`_gdalraster_srs_is_projected`, srs)
}

#' Do these two spatial references describe the same system?
#'
#' `srs_is_same()` returns `TRUE` if these two spatial references describe 
#' the same system. This is a wrapper for `OSRIsSame()` in the GDAL Spatial 
#' Reference System C API.
#'
#' @param srs1 Character OGC WKT string for a spatial reference system
#' @param srs2 Character OGC WKT string for a spatial reference system
#' @return Logical. `TRUE` if these two spatial references describe the same 
#' system, otherwise `FALSE`.
#'
#' @seealso
#' [srs_is_geographic()], [srs_is_projected()]
#'
#' @examples
#' elev_file <- system.file("extdata/storml_elev.tif", package="gdalraster")
#' ds <- new(GDALRaster, elev_file, TRUE)
#' srs_is_same(ds$getProjectionRef(), epsg_to_wkt(26912))
#' srs_is_same(ds$getProjectionRef(), epsg_to_wkt(5070))
#' ds$close()
srs_is_same <- function(srs1, srs2) {
    .Call(`_gdalraster_srs_is_same`, srs1, srs2)
}

#' Get the bounding box of a geometry specified in OGC WKT format
#'
#' `bbox_from_wkt()` returns the bounding box of a WKT 2D geometry 
#' (e.g., LINE, POLYGON, MULTIPOLYGON).
#'
#' @param wkt Character. OGC WKT string for a simple feature 2D geometry.
#' @param extend_x Numeric scalar. Distance to extend the output bounding box
#' in both directions along the x-axis
#' (results in `xmin = bbox[1] - extend_x`, `xmax = bbox[3] + extend_x`).
#' @param extend_y Numeric scalar. Distance to extend the output bounding box
#' in both directions along the y-axis
#' (results in `ymin = bbox[2] - extend_y`, `ymax = bbox[4] + extend_y`).
#' @return Numeric vector of length four containing the xmin, ymin, 
#' xmax, ymax of the geometry specified by `wkt` (possibly extended by values
#' in `extend_x`, `extend_y`).
#'
#' @seealso
#' [bbox_to_wkt()]
#'
#' @examples
#' bnd <- "POLYGON ((324467.3 5104814.2, 323909.4 5104365.4, 323794.2 
#' 5103455.8, 324970.7 5102885.8, 326420.0 5103595.3, 326389.6 5104747.5, 
#' 325298.1 5104929.4, 325298.1 5104929.4, 324467.3 5104814.2))"
#' bbox_from_wkt(bnd, 100, 100)
bbox_from_wkt <- function(wkt, extend_x = 0, extend_y = 0) {
    .Call(`_gdalraster_bbox_from_wkt`, wkt, extend_x, extend_y)
}

#' Convert a bounding box to POLYGON in OGC WKT format
#'
#' `bbox_to_wkt()` returns a WKT POLYGON string for the given bounding box.
#' Requires GDAL built with the GEOS library.
#'
#' @param bbox Numeric vector of length four containing xmin, ymin, 
#' xmax, ymax.
#' @param extend_x Numeric scalar. Distance in units of `bbox` to extend the
#' rectangle in both directions along the x-axis
#' (results in `xmin = bbox[1] - extend_x`, `xmax = bbox[3] + extend_x`).
#' @param extend_y Numeric scalar. Distance in units of `bbox` to extend the
#' rectangle in both directions along the y-axis
#' (results in `ymin = bbox[2] - extend_y`, `ymax = bbox[4] + extend_y`).
#' @return Character string for an OGC WKT polygon.
#' `NA` is returned if GDAL was built without the GEOS library.
#'
#' @seealso
#' [bbox_from_wkt()], [g_buffer()]
#'
#' @examples
#' elev_file <- system.file("extdata/storml_elev.tif", package="gdalraster")
#' ds <- new(GDALRaster, elev_file, read_only=TRUE)
#' bbox_to_wkt(ds$bbox())
#' ds$close()
bbox_to_wkt <- function(bbox, extend_x = 0, extend_y = 0) {
    .Call(`_gdalraster_bbox_to_wkt`, bbox, extend_x, extend_y)
}

