% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom.R
\name{g_binary_pred}
\alias{g_binary_pred}
\alias{g_intersects}
\alias{g_disjoint}
\alias{g_touches}
\alias{g_contains}
\alias{g_within}
\alias{g_crosses}
\alias{g_overlaps}
\alias{g_equals}
\title{Geometry binary predicates operating on WKB or WKT}
\usage{
g_intersects(this_geom, other_geom, quiet = FALSE)

g_disjoint(this_geom, other_geom, quiet = FALSE)

g_touches(this_geom, other_geom, quiet = FALSE)

g_contains(this_geom, other_geom, quiet = FALSE)

g_within(this_geom, other_geom, quiet = FALSE)

g_crosses(this_geom, other_geom, quiet = FALSE)

g_overlaps(this_geom, other_geom, quiet = FALSE)

g_equals(this_geom, other_geom, quiet = FALSE)
}
\arguments{
\item{this_geom}{Either a raw vector of WKB or list of raw vectors, or a
character vector containing one or more WKT strings.}

\item{other_geom}{Either a raw vector of WKB or list of raw vectors, or a
character vector containing one or more WKT strings. Must contain the same
number of geometries as \code{this_geom}.}

\item{quiet}{Logical value, \code{TRUE} to suppress warnings. Defaults to \code{FALSE}.}
}
\value{
Logical vector with length equal to the number of input geometry
pairs.
}
\description{
These functions implement tests for pairs of geometries in OGC WKB or
WKT format.
}
\details{
These functions use the GEOS library via GDAL headers.

\code{g_intersects()} tests whether two geometries intersect.

\code{g_disjoint()} tests if this geometry and the other geometry are disjoint.

\code{g_touches()} tests if this geometry and the other geometry are touching.

\code{g_contains()} tests if this geometry contains the other geometry.

\code{g_within()} tests if this geometry is within the other geometry.

\code{g_crosses()} tests if this geometry and the other geometry are crossing.

\code{g_overlaps()} tests if this geometry and the other geometry overlap, that
is, their intersection has a non-zero area (they have some but not all
points in common).

\code{g_equals()} tests whether two geometries are equivalent.
The GDAL documentation says: "This operation implements the SQL/MM
\code{ST_OrderingEquals()} operation. The comparison is done in a structural way,
that is to say that the geometry types must be identical, as well as the
number and ordering of sub-geometries and vertices. Or equivalently, two
geometries are considered equal by this method if their WKT/WKB
representation is equal. Note: this must be distinguished from equality in
a spatial way."
}
\note{
\code{this_geom} and \code{other_geom} are assumed to be in the same coordinate
reference system.

Geometry validity is not checked. In case you are unsure of the validity
of the input geometries, call \code{g_is_valid()} before, otherwise the result
might be wrong.
}
\seealso{
\url{https://en.wikipedia.org/wiki/DE-9IM}
}
