# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Compute string extents.
#'
#' Determines the width and height of a bounding box that's big enough
#' to (just) enclose the provided text.
#'
#' @param x Character vector of of strings to measure
#' @param bold,italic Is text bold/italic?
#' @param fontname Font name
#' @param fontsize Font size
#' @param fontfile Font file
#' @examples
#' \donttest{
#' # The first run can be slow when font caches are missing
#' # as font files are then being scanned to build those font caches.
#' str_extents(letters)
#' str_extents("Hello World!", bold = TRUE, italic = FALSE,
#'   fontname = "sans", fontsize = 12)
#' }
#' @export
str_extents <- function(x, fontname = "sans", fontsize = 12, bold = FALSE, italic = FALSE, fontfile = "") {
    .Call('gdtools_str_extents', PACKAGE = 'gdtools', x, fontname, fontsize, bold, italic, fontfile)
}

#' Get font metrics for a string.
#'
#' @return A named numeric vector
#' @inheritParams str_extents
#' @examples
#' \donttest{
#' # The first run can be slow when font caches are missing
#' # as font files are then being scanned to build those font caches.
#' str_metrics("Hello World!")
#' }
#' @export
str_metrics <- function(x, fontname = "sans", fontsize = 12, bold = FALSE, italic = FALSE, fontfile = "") {
    .Call('gdtools_str_metrics', PACKAGE = 'gdtools', x, fontname, fontsize, bold, italic, fontfile)
}

context_create <- function() {
    .Call('gdtools_context_create', PACKAGE = 'gdtools')
}

context_set_font <- function(cc, fontname, fontsize, bold, italic, fontfile = "") {
    .Call('gdtools_context_set_font', PACKAGE = 'gdtools', cc, fontname, fontsize, bold, italic, fontfile)
}

context_extents <- function(cc, x) {
    .Call('gdtools_context_extents', PACKAGE = 'gdtools', cc, x)
}

raster_to_str <- function(raster, w, h, width, height, interpolate) {
    .Call('gdtools_raster_to_str', PACKAGE = 'gdtools', raster, w, h, width, height, interpolate)
}

raster_to_file <- function(raster, w, h, width, height, interpolate, filename) {
    .Call('gdtools_raster_to_file', PACKAGE = 'gdtools', raster, w, h, width, height, interpolate, filename)
}

raster_png_ <- function(raster_, w, h, width, height, interpolate, filename) {
    .Call('gdtools_raster_png_', PACKAGE = 'gdtools', raster_, w, h, width, height, interpolate, filename)
}

base64_raster_encode <- function(raster_, w, h, width, height, interpolate) {
    .Call('gdtools_base64_raster_encode', PACKAGE = 'gdtools', raster_, w, h, width, height, interpolate)
}

base64_file_encode <- function(filename) {
    .Call('gdtools_base64_file_encode', PACKAGE = 'gdtools', filename)
}

base64_string_encode <- function(string) {
    .Call('gdtools_base64_string_encode', PACKAGE = 'gdtools', string)
}

#' @title List system fonts.
#'
#' @description List system fonts details into a data.frame containing columns foundry, family,
#' file, slant and weight.
#'
#' @examples
#' \donttest{
#' # The first run can be slow when font caches are missing
#' # as font files are then being scanned to build those font caches.
#' sys_fonts()
#' }
#' @export
sys_fonts <- function() {
    .Call('gdtools_sys_fonts', PACKAGE = 'gdtools')
}

match_family_ <- function(font = "sans", bold = TRUE, italic = TRUE) {
    .Call('gdtools_match_family_', PACKAGE = 'gdtools', font, bold, italic)
}

match_font_ <- function(font = "sans", bold = FALSE, italic = FALSE) {
    .Call('gdtools_match_font_', PACKAGE = 'gdtools', font, bold, italic)
}

#' @rdname version_cairo
#' @export
version_freetype <- function() {
    .Call('gdtools_version_freetype', PACKAGE = 'gdtools')
}

#' @rdname version_cairo
#' @export
version_fontconfig <- function() {
    .Call('gdtools_version_fontconfig', PACKAGE = 'gdtools')
}

version_cairo_ <- function() {
    .Call('gdtools_version_cairo_', PACKAGE = 'gdtools')
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call('gdtools_RcppExport_registerCCallable', PACKAGE = 'gdtools')
})
