% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psd_spade.R
\name{psd_spade}
\alias{psd_spade}
\title{power of spatial determinant(PSD)}
\usage{
psd_spade(y, x, wt)
}
\arguments{
\item{y}{Variable Y, continuous numeric vector.}

\item{x}{Covariable X, \code{factor}, \code{character} or \code{discrete numeric}.}

\item{wt}{The spatial weight matrix.}
}
\value{
A value of power of spatial determinant \code{q_s}.
}
\description{
Function for calculate power of spatial determinant \code{q_s}
}
\details{
The power of spatial determinant formula is

\eqn{q_s = 1 - \frac{\sum_{h=1}^L N_h \Gamma_h}{N \Gamma}}
}
\examples{
data('sim')
wt = inverse_distance_weight(sim$lo,sim$la,power = 2)
psd_spade(sim$y,st_unidisc(sim$xa,5),wt)

}
\references{
Xuezhi Cang & Wei Luo (2018) Spatial association detector (SPADE),International
Journal of Geographical Information Science, 32:10, 2055-2075, DOI:  10.1080/13658816.2018.1476693
}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
