% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/access_fn.R
\name{spectre.area}
\alias{spectre.area}
\title{Get SPECTRE raster segments.}
\usage{
spectre.area(
  index,
  ext = c(-180, 180, -60, 90),
  normalize = FALSE,
  filepath = NULL
)
}
\arguments{
\item{index}{numeric. A vector of integers specifying the layers. Refer to the list.}

\item{ext}{numeric or SpatExtent. A vector of \code{xmin}, \code{xmax}, \code{ymin}, \code{ymax} or a \code{terra} 
spatial extent object (See \code{\link[terra:ext]{terra::ext()}}). If no 
input is given, an extent of \code{xmin = -180, xmax = 180, ymin = -60, ymax = 90} is selected.}

\item{normalize}{character or logical. Either logical on whether data should be normalized 
for the given interval or a character specifying a type of normalization. Type
default to "standard". Check \code{\link[gecko:normalize]{gecko::normalize()}}
for more info.}

\item{filepath}{character. An optional user defined path for the final output. If \code{NULL}, requested files are left in the current temp directory.}
}
\value{
SpatRaster.
}
\description{
Downloads SPECTRE segments according to a bounding box selection.
}
\examples{
\dontrun{
regional_threats = spectre.area(3, terra::ext(-17.3,-16.6,32.6,32.9), normalize = FALSE)
terra::plot(regional_threats[[1]], main = "Human Density")
}
}
