% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen3sis_main.R
\name{run_simulation}
\alias{run_simulation}
\title{run a simulation in gen3sis and return a summary object possibly saving outputs and plots to the output folder.}
\usage{
run_simulation(
  config = NA,
  landscape = NA,
  output_directory = NA,
  timestep_restart = NA,
  save_state = NA,
  call_observer = "all",
  enable_gc = FALSE,
  verbose = 1
)
}
\arguments{
\item{config}{configuration file for the simulation or configuration object derived from a config file}

\item{landscape}{directory where the all_geo_hab and distance_matrices reside}

\item{output_directory}{directory for the simulation output}

\item{timestep_restart}{= set the start time time-step. If NA start at the beginning, If "ti" start from the last available time-step, if a number "x" start from timestep x}

\item{save_state}{= save the internal state of the simulation for restarts. If "all" save all time-step, if a vector, saves the desired time-steps if "last", saves only last timestep}

\item{call_observer}{call observer functions if any, NA calls at the start and end times, "all" call all time-steps, You can also provide the number of time-steps equaly spaced between start and end steps, that the observer function is called}

\item{enable_gc}{enable gc in case of memory shortages}

\item{verbose}{integer value (0, 1 ,2 or 3). If 0 no printed statement, 1 time-step progress, 2 enable additional progress outputs regarding current time-step, 3 aditional information from within modules (default is 1)}
}
\value{
a summary object containing a minimal summary on simulation and dynamics progress (alive, speciations, extinctions) and some useful simulation data
}
\description{
run a simulation in gen3sis and return a summary object possibly saving outputs and plots to the output folder.
}
\details{
run a simulation with defined landscape and config objects. Possibly plot and save specified outputs as defined in the end_of_timestep_observer function inside the config object
}
\examples{
\donttest{
# get path or correct input objects
datapath <- system.file(file.path("extdata", "CaseStudy1"), package="gen3sis")

# run simulation and store summary obejct to sim
sim <- run_simulation(config = file.path(datapath,"config/config_fast.R"), 
                landscape = file.path(datapath,"landscape"),
                output_directory = tempdir())

# plot summary object
plot_summary(sim)
}
}
\seealso{
\code{\link{plot_summary}}   \code{\link{create_input_config}}   \code{\link{create_input_landscape}}
}
