% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BCdata-class-methods.R
\name{setReads}
\alias{setReads}
\title{Replacing the Read-Count slot of a BCdat objects.}
\usage{
setReads(object, value)
}
\arguments{
\item{object}{a BCdat object.}

\item{value}{a data.frame caontaining two columns called "read_count" and "barcode".}
}
\value{
a BCdat object.
}
\description{
Replacing the Read-Count slot of a BCdat objects.
}
\examples{
data(BC_dat)
require("dplyr")

bcs <- unlist(lapply(1:20, function(x) {
           c("A", "C", "T", "G") \%>\% sample(replace = TRUE, size = 32) \%>\% paste0(collapse = "")
       }))
new_read_count_table <- data.frame(read_count = sample(1:1000, size = 20), barcode = bcs)
BC_dat_alt <- setReads(BC_dat, new_read_count_table)

}
