% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaData.R
\name{metaData}
\alias{metaData}
\title{Declare meta data information for downstream analysis}
\usage{
metaData(y, design, data.type = "microarray", columnname = NULL,
  long = FALSE, time.var = NULL, sample.id = NULL, subject.id = NULL,
  baseline.var = NULL, baseline.val = NULL, control.var = NULL,
  control.val = NULL)
}
\arguments{
\item{y}{An expression data frame.}

\item{design}{A sample annotation data frame containing sample information
(e.g. age, condition, timepoint, etc.).}

\item{data.type}{Type of data that's going to be analyzed ("microarray", 
"rnaseq","flow", "metab"). Default is data.type="microarray".}

\item{columnname}{Name of column in design that contains the column names of 
y.}

\item{long}{logical; Is the study longitudinal?.}

\item{time.var}{For longitudinal studies. Name of column in design that 
contains the study time points.}

\item{sample.id}{Name of column in design that contains unique sample 
identification.}

\item{subject.id}{Name of column in design that contains ids for individual
subjects.}

\item{baseline.var}{Name of column in design that contains values referring 
to baseline observations.}

\item{baseline.val}{String or numeric value denoting baseline observations.}

\item{control.var}{Name of column in design that contains values referring to
controls.}

\item{control.val}{String or numeric value denoting controls.}
}
\value{
A list containing the matched design and expression data and all of 
  the design parameters specified.
}
\description{
Match design and expression data frames. Declare and store design parameters.
}
\examples{
# Using example data
data(tb.expr)
data(tb.design)
meta.data <- metaData(y = tb.expr, design = tb.design, data.type = "microarray", 
                    columnname = "columnname", long = TRUE, sample.id = "sample_id",
                    subject.id = "monkey_id", time.var = "timepoint",
                    baseline.var = "timepoint", baseline.val = 0)
}
