% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotVenn.R
\name{plotVenn}
\alias{plotVenn}
\title{Venn plot for groups of genes}
\usage{
plotVenn(
  venn_list,
  use_venn = TRUE,
  color = NULL,
  alpha_degree = 0.3,
  venn_percent = FALSE,
  ...
)
}
\arguments{
\item{venn_list}{A list of gene id.}

\item{use_venn}{Logical, use venn to plot, default is `TRUE`, the other
option is upsetplot for large list.}

\item{color}{Colors for gene lists, default is NULL.}

\item{alpha_degree}{Alpha transparency of each circle's area, default is 0.3.}

\item{venn_percent}{Logical to show both number and percentage in venn plot.}

\item{...}{other arguments transfer to `plot_theme` function}
}
\value{
A ggplot object
}
\description{
If gene group over 4, plot will be visulized using UpSet plot.
}
\examples{
library(ggplot2)
set1 <- paste0(rep("gene", 30), sample(1:1000, 30))
set2 <- paste0(rep("gene", 40), sample(1:1000, 40))
set3 <- paste0(rep("gene", 50), sample(1:1000, 50))
set4 <- paste0(rep("gene", 60), sample(1:1000, 60))
set5 <- paste0(rep("gene", 70), sample(1:1000, 70))
sm_gene_list <- list(gset1 = set1, gset2 = set2, gset3 = set3)
la_gene_list <- list(
  gset1 = set1, gset2 = set2, gset3 = set3,
  gset4 = set4, gset5 = set5
)
plotVenn(sm_gene_list,
  use_venn = TRUE,
  color = ggsci::pal_lancet()(3),
  alpha_degree = 0.5,
  main_text_size = 3,
  border_thick = 0,
  venn_percent = TRUE
)
plotVenn(la_gene_list,
  use_venn = FALSE,
  main_text_size = 15,
  legend_text_size = 8,
  legend_position = 'left'
)
}
