% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Genepop.R
\name{conversion}
\alias{conversion}
\title{File conversions}
\usage{
conversion(inputFile, format, outputFile = "", verbose = interactive())
}
\arguments{
\item{inputFile}{The path of the input file, in Genepop format}

\item{format}{Character string: must be one of \code{'Fstat'}, \code{'BiosysL'}, \code{'BiosysN'}, or \code{'Linkdos'}}

\item{outputFile}{character: The path of the output file}

\item{verbose}{logical: whether to print some information}
}
\value{
The path of the output file is returned invisibly.
}
\description{
Converts input files from genepop format to some other formats (some maybe only of historical interest): Fstat, two Biosys formats. and linkdos. See \href{../doc/all-menu-options.html#option-7-file-conversions}{this section} of the Genepop executable documentation for more information on the statistical methods.
}
\examples{
infile <- system.file('extdata', 'sample.txt',package='genepop')
locinfile <- 'sample.txt'
check <- file.copy(infile,locinfile,overwrite=TRUE)
conversion(locinfile, format='Fstat', 'sample.txt.DAT')
}
