% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_snp.R
\name{write_snp}
\alias{write_snp}
\title{Write eigenstrat *.snp files}
\usage{
write_snp(file, tib, verbose = TRUE)
}
\arguments{
\item{file}{Output file (whatever is accepted by readr::write_tsv).
If file is missing the expected *.snp extension, the function adds it.}

\item{tib}{The tibble or data.frame to write.
It must contain these columns: id, chr, posg, pos, ref, alt
Throws an error if any of these columns are missing.
Additional columns are ignored.
Columns are automatically reordered in output as expected in format.}

\item{verbose}{If TRUE (default) function reports the path of the file being written (after autocompleting the extension).}
}
\value{
The input \code{tib} invisibly (what readr::write_tsv returns).
}
\description{
This function writes a tibble with the right columns into a standard eigenstrat *.snp file.
It uses readr::write_tsv to do it efficiently.
}
\examples{
# create a dummy tibble with the right columns
library(tibble)
tib <- tibble(
    id = 1:3,
    chr = 1:3,
    posg = 0,
    pos = 1:3,
    ref = 'A',
    alt = 'B'
)
# a dummy file
file_out <- tempfile('delete-me-example', fileext = '.snp') # will also work without extension
# write the table out in *.snp format (no header, columns in right order)
write_snp(file_out, tib)
# delete output when done
file.remove(file_out)

}
\seealso{
Eigenstrat SNP format reference:
\url{https://github.com/DReichLab/EIG/tree/master/CONVERTF}
}
