% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_snp.R
\name{read_snp}
\alias{read_snp}
\title{Read Eigenstrat *.snp files}
\usage{
read_snp(file, verbose = TRUE)
}
\arguments{
\item{file}{Input file (whatever is accepted by \code{\link[readr:read_table]{readr::read_table2()}}).
If file as given does not exist and is missing the expected *.snp extension, the function adds the .snp extension and uses that path if that file exists.
Additionally, the .gz extension is added automatically if the file (after *.snp extension is added as needed) is still not found and did not already contain the .gz extension and adding it points to an existing file.}

\item{verbose}{If \code{TRUE} (default), function reports the path of the file being loaded (after autocompleting the extensions).}
}
\value{
A tibble with columns: \code{id}, \code{chr}, \code{posg}, \code{pos}, \code{ref}, \code{alt}
}
\description{
This function reads a standard Eigenstrat *.snp file into a tibble.
It uses \code{\link[readr:read_table]{readr::read_table2()}} to do it efficiently.
}
\examples{
# to read "data.snp", run like this:
# snp <- read_snp("data")
# this also works
# snp <- read_snp("data.snp")

# The following example is more awkward
# because package sample data has to be specified in this weird way:

# read an existing Eigenstrat *.snp file
file <- system.file("extdata", 'sample.snp', package = "genio", mustWork = TRUE)
snp <- read_snp(file)
snp

# can specify without extension
file <- sub('\\\\.snp$', '', file) # remove extension from this path on purpose
file # verify .snp is missing
snp <- read_snp(file) # load it anyway!
snp

}
\seealso{
Eigenstrat SNP format reference:
\url{https://github.com/DReichLab/EIG/tree/master/CONVERTF}
}
