% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_plink.R
\name{read_plink}
\alias{read_plink}
\title{Read genotype and sample data in a plink BED/BIM/FAM file set.}
\usage{
read_plink(file, verbose = TRUE)
}
\arguments{
\item{file}{Input file path, without extensions (each of .bed, .bim, .fam extensions will be added automatically as needed).
Alternatively, input file path may have .bed extension (but not .bim, .fam, or other extensions).}

\item{verbose}{If TRUE (default) function reports the paths of the files being read (after autocompleting the extensions).}
}
\value{
A named list with items in this order: X (genotype matrix), bim (tibble), fam (tibble).
X has row and column names corresponding to the \code{id} values of the bim and fam tibbles.
}
\description{
This function reads a genotype matrix (X) and its associated locus (bim) and individual (fam) data tables in the three plink files in BED, BIM, and FAM formats, respectively.
All inputs must exist or an error is thrown.
This function is a wrapper around the more basic functions
\code{\link{read_bed}},
\code{\link{read_bim}},
\code{\link{read_fam}}.
Below suppose there are \eqn{m} loci and \eqn{n} individuals.
}
\examples{
# first get path to BED file
file <- system.file("extdata", 'sample.bed', package = "genio", mustWork = TRUE)

# read genotypes and annotation tables
plink_data <- read_plink(file)
# genotypes
plink_data$X
# locus annotations
plink_data$bim
# individual annotations
plink_data$fam

# the same works without .bed extension
file <- sub('\\\\.bed$', '', file) # remove extension
# it works!
plink_data <- read_plink(file)

}
\seealso{
\code{\link{read_bed}},
\code{\link{read_bim}},
\code{\link{read_fam}}.

Plink BED/BIM/FAM format reference:
\url{https://www.cog-genomics.org/plink/1.9/formats}
}
