% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize_genotypeR_data.R
\name{initialize_genotypeR_data}
\alias{initialize_genotypeR_data}
\title{initialize_genotypeR_data; must provide warning allele}
\usage{
initialize_genotypeR_data(seq_data, genotype_table, warning_allele = "Ref",
  output = "pass_through")
}
\arguments{
\item{seq_data}{is a data frame of genotyping data}

\item{genotype_table}{data frame produced with Ref_Alt_Table}

\item{warning_allele}{is the impossible allele for a BC design
taking the value "Ref" or "Alt"}

\item{output}{this can take 3 values: 1) "warnings" which returns
a data frame of BC warnings, 2) "warnings2NA" which returns a
genotyping data frame where the warnings have been converted to NAs,
or "pass_through" which returns a data frame that is unchanged (default).}
}
\value{
A genotypeR object
}
\description{
This initializes the genotypeR data structure used throughout
the package.
}
\examples{

data(genotypes_data)
data(markers)
## genotype table
marker_names <- make_marker_names(markers)
GT_table <- Ref_Alt_Table(marker_names)
## remove those markers that did not work
genotypes_data_filtered <- genotypes_data[,c(1, 2, grep("TRUE",
colnames(genotypes_data)\%in\%GT_table$marker_names))]

warnings_out2NA <- initialize_genotypeR_data(seq_data = genotypes_data_filtered,
genotype_table = GT_table, output = "warnings2NA")

}
\keyword{genotypeR}
