% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pls.R
\name{pls}
\alias{pls}
\title{PLS-SEM: Partial Least Squares Structural Equation Modeling}
\usage{
pls(
  x,
  inner,
  outer,
  modes,
  scheme = "path",
  scaled = TRUE,
  tol = 1e-05,
  iter = 100,
  ...
)
}
\arguments{
\item{x}{matrix or data frame containing the manifest variables}

\item{inner}{a square (lower triangular) boolean matrix representing 
the inner model (i.e. the path relationships between latent variables)}

\item{outer}{list of vectors with column indices or column names
from \code{Data} indicating the sets of manifest variables forming 
each block (i.e. which manifest variables correspond to each block)}

\item{modes}{character vector indicating the type of measurement for each
block. Possible values are: \code{"A", "B"} 
The length of \code{modes} must be equal to the length of \code{blocks}}

\item{scheme}{string indicating the type of inner weighting
scheme. Possible values are \code{"centroid"}, \code{"factorial"}, or
\code{"path"}}

\item{tol}{decimal value indicating the tolerance criterion for the
iterations (\code{tol=0.000001}). Can be specified between 0 and 0.001}

\item{iter}{integer indicating the maximum number of iterations
(\code{maxiter=100} by default). The minimum value of \code{maxiter} is 100}
}
\value{
a list with score, path coefs and R2
}
\description{
Estimate score and path coefficient applying a partial least squares approach
}
\details{
############################################################################################


Internal function
}
\keyword{internal}
