% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_function.R
\name{ss.plot}
\alias{ss.plot}
\title{Function to Plot Sample Size Results}
\usage{
ss.plot(data = NULL, x = "MAF", panel.by = "True.Model",
  y_limit = NULL, y_log = F, return_gg = F,
  linear.effect.measure = "ES", select.Alpha = NULL,
  select.OR = NULL, select.ES = NULL, select.Power = NULL,
  select.MAF = NULL, select.Case.Rate = NULL, select.SD = NULL,
  select.True.Model = NULL, select.Test.Model = NULL)
}
\arguments{
\item{data}{The data frame result from \code{\link{ss.calc}}}

\item{x}{The desired variable on the y axis: "MAF", "OR", "ES","Alpha", or "Power"}

\item{panel.by}{A grouping variable to panel the graphs by: "True.Model", "MAF", "OR", "Alpha", or "Power"}

\item{y_limit}{An object specifying the minimum and maximum of the y-axis (eg c(0,4)) default is NULL, which allows the limits to be picked automatically}

\item{y_log}{Logical, specifying whether the y axis should be logarithmic. Default is F}

\item{return_gg}{Logical, specifying whether to return the ggplot object instead of printing out the plot}

\item{linear.effect.measure}{Should the graphs indicate ES values, or R2 values? (default ES)}

\item{select.Alpha}{Only produce graphs for the specified Alpha level(s).}

\item{select.OR}{Only produce graphs for the specified odds ratio(s).}

\item{select.ES}{Only produce graphs for the specified effect size(s).}

\item{select.Power}{Only produce graphs for the specified power(s).}

\item{select.MAF}{Only produce graphs for the specified minor allele frequency(ies).}

\item{select.Case.Rate}{Only produce graphs for the specified case rate(s).}

\item{select.SD}{Only produce graphs for the specified standard deviation(s).}

\item{select.True.Model}{Only produce graphs for the specified true genetic model(s): "Additive", "Dominant", "Recessive".}

\item{select.Test.Model}{Only produce graphs for the specified testing model(s): "Additive", "Dominant", "Recessive", "2df".}
}
\value{
A series of plots with sample size on the Y axis.
}
\description{
Plot the sample size results by MAF, OR, Alpha or Power
}
\examples{
ss <- ss.calc(power=0.8, Case.Rate=c(0.5), k=NULL,
    MAF=seq(0.01, 0.05, 0.01), OR=c(4),Alpha=c(0.05),
    True.Model='All', Test.Model='All')
ss.plot(data=ss, x='MAF',panel.by='OR')

}
