% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cells.R
\name{cells_search}
\alias{cells_search}
\title{Search Cell Information Based on Query Conditions}
\usage{
cells_search(
  queryValues,
  fieldsFilter = c("geneID", "symbol", "crossReference.enseGeneID"),
  excludeFields = NULL,
  page = 1,
  limit = 10,
  searchType = "and",
  orderBy = "geneID",
  sortDirection = "asc",
  responseType = "json",
  matchType = "exact",
  organismType = list(c("9606")),
  debug = 0,
  options = list()
)
}
\arguments{
\item{queryValues}{A named list where keys are cell IDs and values are condition strings
indicating the expression score criteria.}

\item{fieldsFilter}{A character vector specifying which fields to include in the response.}

\item{excludeFields}{If fieldsFilter is not provided (empty), all fields are returned, here you can specify the fields you want to exclude.}

\item{page}{An integer specifying the page number for pagination of results.}

\item{limit}{An integer specifying the maximum number of results to return per page.}

\item{searchType}{A character string indicating whether to use 'and' or 'or' logic for multiple search conditions.}

\item{orderBy}{The field name by which to order the returned results.}

\item{sortDirection}{The direction of sorting, which can be either "asc" for ascending or "desc" for descending.}

\item{responseType}{A character string indicating the type of response to expect ('json' or 'csv').}

\item{matchType}{A character string indicating the type of match to perform ('exact' or 'regex').}

\item{organismType}{A list of organism type IDs to filter the search results.}

\item{debug}{An integer value indicating whether to enable debug mode (1) or not (0).}

\item{options}{A list containing additional options for the API request, including the endpoint, api_key, timeout, and user-agent.}
}
\value{
A list containing detailed information about the cells that meet the search criteria, including the requested fields.
}
\description{
This function interacts with the 'Genular' API to search for cell information based on specific
query conditions related to cell IDs and expression marker scores. It sends a POST request
with these conditions and retrieves matching cell information.
}
\examples{
\donttest{
queryValues <- list("CL0001082" = ">= 250")
fieldsFilter <- c("geneID", "symbol")
cell_search_results <- cells_search(queryValues, fieldsFilter)
print(cell_search_results)
}
}
