% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtset.r
\name{xtset}
\alias{xtset}
\title{prepares a panel dataset for lag operations}
\usage{
xtset(timevar, obsvar)
}
\arguments{
\item{timevar}{the name of the variable to for the time dimension}

\item{obsvar}{the name of the variable to use for the observation dimension}
}
\value{
returns NULL, invisibly
}
\description{
prepares a panel dataset for lag operations.  The lag function in R is simply "lag(var,numlags)".  After calling \code{xtset}, this lag function will work on the panel in the way you would expect.
}
\examples{
library(plm)
data(Produc)
use(Produc, clear=TRUE)
xtset("year", "state")
gen("Lemp", "lag(emp)")
listif(vars="emp Lemp")
reg("emp", "unemp", effect="twoway")
reg("emp", "unemp", effect="individual")
reg("emp", "unemp", effect="time")
}
