% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kriging.R
\name{log_lik_rf}
\alias{log_lik_rf}
\title{Maximum likelihood estimate for \eqn{\sigma^2}, \eqn{\phi} and \eqn{\rho}.}
\usage{
log_lik_rf(m_coef, m_coord)
}
\arguments{
\item{m_coef}{Matrix where each column is an observed vector}

\item{m_coord}{Matrix where each observation contains the latitude and
longitude}
}
\value{
Return a list with
\describe{
\item{par}{A vector with the estimates of \eqn{\sigma^2}, \eqn{\phi} and
\eqn{\rho}.}
\item{m_cov}{A matrix of covariances of the estimates.}
}
}
\description{
This function maximum likelihood estimate for \eqn{\sigma^2}, \eqn{\phi}
and \eqn{\rho} in the random field model for the covariance.
}
\examples{
data("datasetCanada")

m_data <- as.matrix(datasetCanada$m_data)
m_coord <- as.matrix(datasetCanada$m_coord[, 1:2])

p <- ceiling(1 + log2(nrow(m_data)))
m_coef <- sapply(seq_len(nrow(m_coord)), function(i) {
    coef_fourier(m_data[, i], p)
})
log_lik_rf(m_coef, m_coord)
}
