% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotIntersect.r
\docType{methods}
\name{plotIntersect}
\alias{plotIntersect}
\alias{plotIntersect,ProfileSet,ANY-method}
\alias{plotIntersect,Profile,Profile-method}
\title{Plot Profile Intersection}
\usage{
plotIntersect(.Object1, .Object2 = NULL,
  xlab = "Height above sea level [m]",
  ylab = expression(paste("Resistivity [", Omega, "m]")), main = "",
  trafo = log, backtrafo = exp, col = colors, pch = c(20, 20),
  type = "p", legendLoc = "bottomleft")

\S4method{plotIntersect}{ProfileSet,ANY}(.Object1, xlab, ylab, main, trafo,
  backtrafo, col, pch, type, legendLoc)

\S4method{plotIntersect}{Profile,Profile}(.Object1, .Object2 = NULL,
  xlab = "Height above sea level [m]",
  ylab = expression(paste("Resistivity [", Omega, "m]")), main = "",
  trafo = log, backtrafo = exp, col = colors, pch = c(20, 20),
  type = "p", legendLoc = "bottomleft")
}
\arguments{
\item{.Object1}{either a single Profile or a ProfileSet.}

\item{.Object2}{either a second single Profile or NULL if .Object1 is of type ProfileSet.}

\item{xlab}{label of the x-axes, e.g. length [m].}

\item{ylab}{label of the y-axes, e.g. height above sea level [m].}

\item{main}{title to be plotted.}

\item{trafo}{transformation to be done on data (default: log).}

\item{backtrafo}{back transformation to plot correct labels (default: exp).}

\item{col}{character vector of colors.}

\item{pch}{numeric vector of plotting symbols.}

\item{type}{plot type (default "p" for points).
"b" for both points and lines, "c" for empty points joined by lines,
"o" for overplotted points and lines,
"s" and "S" for stair steps and "h" for histogram-like vertical lines.
Finally, "n" does not produce any points or lines.}

\item{legendLoc}{legendLocation (default "bottomleft").}
}
\description{
Plots resistivity against height on and next to the intersection line
between two profiles.
}
\examples{
data(sinkhole)

plotIntersect(sinkhole)
plotIntersect(sinkhole@profiles[[1]], sinkhole@profiles[[2]])
}
\seealso{
\code{\link{ProfileSet-class}}
}
