% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.R
\name{estimate_up}
\alias{estimate_up}
\title{Estimate Up Levels}
\usage{
estimate_up(value, group)
}
\arguments{
\item{value}{numeric vector. Defaults to 1. Typically population values.}

\item{group}{matches of length(value) that correspond to row indices of value. 
Often, this input is the output of geo_match.}
}
\value{
numeric vector with each value aggregated by group
}
\description{
Non-geographic partner function to geo_estimate_up. Allows users to aggregate
up without the costly matching operation if they've already matched.
}
\examples{
library(dplyr)
set.seed(1)
data(checkerboard)
counties <- checkerboard \%>\% group_by(id <= 32) \%>\% 
summarize(geometry = sf::st_union(geometry)) \%>\% mutate(pop = c(100,200))
matches <- geo_match(checkerboard, counties) 
estimate_up(value = checkerboard$i, group = matches)

}
\concept{estimate}
