% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOCitation.R
\docType{class}
\name{ISOCitation}
\alias{ISOCitation}
\title{ISOCitation}
\format{\code{\link{R6Class}} object.}
\usage{
ISOCitation
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO Citation
}
\description{
ISOCitation
}
\section{Fields}{

\describe{
\item{\code{presentationForm}}{}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an ISOCitation
 }
 \item{\code{setTitle(title)}}{
   Sets the title
 }
 \item{\code{setAlternateTitle(alternateTitle)}}{
   Sets an alternate title
 }
 \item{\code{addDate(date)}}{
   Adds the date (ISODate object containing date and dateType)
 }
 \item{\code{setEdition(edition)}}{
   Sets the edition
 }
 \item{\code{setEditionDate(editionDate)}}{
   Sets the edition date, either an ISODate object containing date and dateType or
   a simple R date "POSIXct"/"POSIXt" object. For thesaurus citations, an ISODate
   should be used while for the general citation of \code{ISODataIdentification},
   a simple R date should be used.
 }
 \item{\code{setIdentifier(identifier)}}{
   Sets the identifier as object of class 'ISOMetaIdentifier'
 }
 \item{\code{seCitedResponsibleParty(rp)}}{
   Sets the cited responsiblep party
 }
 \item{\code{setPresentationForm}}{
   Sets the presentation form
 }
}
}

\examples{
 #create ISOCitation
 md <- ISOCitation$new()
 md$setTitle("sometitle")
 md$setEdition("1.0")
 md$setEditionDate(ISOdate(2015,1,1))
 md$setIdentifier(ISOMetaIdentifier$new(code = "identifier"))
 md$setPresentationForm("mapDigital")
 
 #add a cited responsible party
 rp <- ISOResponsibleParty$new()
 rp$setIndividualName("someone")
 rp$setOrganisationName("somewhere")
 rp$setPositionName("someposition")
 rp$setRole("pointOfContact")
 contact <- ISOContact$new()
 phone <- ISOTelephone$new()
 phone$setVoice("myphonenumber")
 phone$setFacsimile("myfacsimile")
 contact$setPhone(phone)
 address <- ISOAddress$new()
 address$setDeliveryPoint("theaddress")
 address$setCity("thecity")
 address$setPostalCode("111")
 address$setCountry("France")
 address$setEmail("someone@theorg.org")
 contact$setAddress(address)
 res <- ISOOnlineResource$new()
 res$setLinkage("http://www.somewhereovertheweb.org")
 res$setName("somename")
 contact$setOnlineResource(res)
 rp$setContactInfo(contact)
 md$setCitedResponsibleParty(rp)
 xml <- md$encode()
 
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{citation}
