% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOAddress.R
\docType{class}
\name{ISOAddress}
\alias{ISOAddress}
\title{ISOAddress}
\format{\code{\link{R6Class}} object.}
\usage{
ISOAddress
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO Address
}
\description{
ISOAddress
}
\section{Fields}{

\describe{
\item{\code{electronicMailAddress}}{}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an ISOAddress
 }
 \item{\code{setDeliveryPoint(deliveryPoint)}}{
   Sets the delivery point
 }
 \item{\code{setCity(city)}}{
   Sets the city
 }
 \item{\code{setPostalCode(postalCode)}}{
   Sets the postal code
 }
 \item{\code{setCountry(country)}}{
   Sets the country
 }
 \item{\code{setEmail(email)}}{
   Sets the electronic Mail address
 }
}
}

\examples{
 md <- ISOAddress$new()
 md$setDeliveryPoint("theaddress")
 md$setCity("thecity")
 md$setPostalCode("111")
 md$setCountry("France")
 md$setEmail("someone@theorg.org")
 xml <- md$encode()
 
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{address}
