% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOOnlineResource.R
\docType{class}
\name{ISOOnlineResource}
\alias{ISOOnlineResource}
\title{ISOOnlineResource}
\format{\code{\link{R6Class}} object.}
\usage{
ISOOnlineResource
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO Online Resource
}
\description{
ISOOnlineResource
}
\section{Fields}{

\describe{
\item{\code{function}}{}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an ISOOnlineResource
 }
 \item{\code{setLinkage(linkage)}}{
   Sets the linkage (URL), an object of class \code{character} or \code{ISOUrl}
 }
 \item{\code{setProtocol(protocol)}}{
   Sets the protocol
 }
 \item{\code{setName(name)}}{
   Sets the name
 }
 \item{\code{setDescription(description)}}{
   Sets the description
 }
 \item{\code{setOnLineFunction(onLineFunction)}}{
   Sets the online function
 }
}
}

\examples{
  md <- ISOOnlineResource$new()
  md$setLinkage("http://somelink")
  md$setName("name")
  md$setDescription("description")
  md$setProtocol("protocol")
  md$setOnLineFunction("download")
  xml <- md$encode()
  
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{online}
\keyword{resource}
