% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOImageryEnvironmentalRecord.R
\docType{class}
\name{ISOImageryEnvironmentalRecord}
\alias{ISOImageryEnvironmentalRecord}
\title{ISOImageryEnvironmentalRecord}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO imagery environmental record
}
\description{
ISOImageryEnvironmentalRecord
}
\section{Fields}{

\describe{
\item{\code{averageAirTemperature}}{[\code{\link{numeric}}]}

\item{\code{maxRelativeHumidity}}{[\code{\link{numeric}}]}

\item{\code{maxAltitude}}{[\code{\link{numeric}}]}

\item{\code{meterologicalConditions}}{[\code{\link{ISOBaseCharacterString}|\link{ISOLocalisedCharacterString}}]}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOImageryEnvironmentalRecord}}
 }
 \item{\code{setAverageAirTemperature(temperature)}}{
   Set the average air temperature
 }
 \item{\code{setMaxRelativeHumidity(humidity)}}{
   Set the max relative humidity
 }
 \item{\code{setMaxAltitude(altitude)}}{
   Set the max altitude
 }
 \item{\code{setMeterologicalConditions(conditions)}}{
   Set the meterological conditions. Locale names can be specified as \code{list}
   with the \code{locales} argument.
 }
}
}

\examples{
   md <- ISOImageryEnvironmentalRecord$new()
   md$setAverageAirTemperature(3)
   md$setMaxRelativeHumidity(67)
   md$setMaxAltitude(400)
   md$setMeterologicalConditions("some conditions")
   xml <- md$encode()

}
\references{
ISO 19115-2:2009 - Geographic information -- Metadata Part 2: Extensions for imagery and gridded data
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{environmental}
\keyword{imagery}
\keyword{record}
