% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOServiceIdentification.R
\docType{class}
\name{ISOServiceIdentification}
\alias{ISOServiceIdentification}
\title{ISOServiceIdentification}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO ServiceIdentification
}
\description{
ISOServiceIdentification
}
\section{Methods inherited from \code{\link{ISOIdentification}}}{

\describe{
 \item{\code{setCitation(citation)}}{
   Sets an object of class \code{\link{ISOCitation}}
 }
 \item{\code{setAbstract(abstract, locales)}}{
   Sets an abstract (object of class "character"). Locale names can be 
   specified as \code{list} with the \code{locales} argument.
 }
 \item{\code{setPurpose(purpose, locales)}}{
   Sets a purpose (object of class "character"). Locale names can be 
   specified as \code{list} with the \code{locales} argument.
 }
 \item{\code{addCredit(credit, locales)}}{
   Adds a credit (object of class "character"). Locale names can be 
   specified as \code{list} with the \code{locales} argument.
 }
 \item{\code{delCredit(credit, locales)}}{
   Deletes a credit (object of class "character"). Locale names can be 
   specified as \code{list} with the \code{locales} argument.
 }
 \item{\code{addStatus(status)}}{
   Adds a status, as object of class "character" or class \code{\link{ISOStatus}}. If
   an object of class "character" is specified, it must match the accepted
   progress status values \code{ISOStatus$values()}.
 }
 \item{\code{delStatus(status)}}{
   Deletes a status, as object of class "character" or class \code{\link{ISOStatus}}. If
   an object of class "character" is specified, it must match the accepted
   progress status values \code{ISOStatus$values()}.
 }
 \item{\code{addPointOfContact(pointOfContact)}}{
   Adds an object of class \code{\link{ISOResponsibleParty}}
 }
 \item{\code{delPointOfContact(pointOfContact)}}{
   Deletes an object of class \code{\link{ISOResponsibleParty}}
 }
 \item{\code{addResourceMaintenance(resourceMaintenance)}}{
   Adds a resource maintenance information as object of class 
   \code{\link{ISOMaintenanceInformation}}.
 }
 \item{\code{setResourceMaintenance(resourceMaintenance)}}{
   Sets a resource maintenance information as object of class 
   \code{\link{ISOMaintenanceInformation}}.
 }
 \item{\code{delResourceMaintenance(resourceMaintenance)}}{
   Deletes a resource maintenance information as object of class 
   \code{\link{ISOMaintenanceInformation}}.
 }
 \item{\code{addGraphicOverview(graphicOverview)}}{
   Adds an object of class \code{\link{ISOBrowseGraphic}}
 }
 \item{\code{setGraphicOverview(graphicOverview)}}{
   Sets an object of class \code{\link{ISOBrowseGraphic}}
 }
 \item{\code{delGraphicOverview(graphicOverview)}}{
   Deletes an object of class \code{\link{ISOBrowseGraphic}}
 }
 \item{\code{addKeywords(keywords)}}{
   Adds a set of keywords as object of class \code{\link{ISOKeywords}}
 }
 \item{\code{setKeywords(keywords)}}{
   Sets a set of keywords as object of class \code{\link{ISOKeywords}}
 }
 \item{\code{delKeywords(keywords)}}{
   Deletes a set of keywords as object of class \code{\link{ISOKeywords}}
 }
 \item{\code{addResourceConstraints(resourceConstraints)}}{
   Adds an object of class \code{\link{ISOLegalConstraints}}
 }
 \item{\code{setResourceConstraints(resourceConstraints)}}{
   Sets an object of class \code{\link{ISOLegalConstraints}}
 }
 \item{\code{addResourceConstraints(resourceConstraints)}}{
   Deletes an object of class \code{ISOLegalConstraints}
 }
}
}

\examples{
  #encoding
  md <- ISOServiceIdentification$new()
  md$setAbstract("abstract")
  md$setPurpose("purpose")

  #adding a point of contact
  rp <- ISOResponsibleParty$new()
  rp$setIndividualName("someone")
  rp$setOrganisationName("somewhere")
  rp$setPositionName("someposition")
  rp$setRole("pointOfContact")
  contact <- ISOContact$new()
  phone <- ISOTelephone$new()
  phone$setVoice("myphonenumber")
  phone$setFacsimile("myfacsimile")
  contact$setPhone(phone)
  address <- ISOAddress$new()
  address$setDeliveryPoint("theaddress")
  address$setCity("thecity")
  address$setPostalCode("111")
  address$setCountry("France")
  address$setEmail("someone@theorg.org")
  contact$setAddress(address)
  res <- ISOOnlineResource$new()
  res$setLinkage("http://www.somewhereovertheweb.org")
  res$setName("somename")
  contact$setOnlineResource(res)
  rp$setContactInfo(contact)
  md$addPointOfContact(rp)

  #citation
  ct <- ISOCitation$new()
  ct$setTitle("sometitle")
  d <- ISODate$new()
  d$setDate(ISOdate(2015, 1, 1, 1))
  d$setDateType("publication")
  ct$addDate(d)
  ct$setEdition("1.0")
  ct$setEditionDate(ISOdate(2015,1,1))
  ct$addIdentifier(ISOMetaIdentifier$new(code = "identifier"))
  ct$addPresentationForm("mapDigital")
  ct$addCitedResponsibleParty(rp)
  md$setCitation(ct)

  #graphic overview
  go <- ISOBrowseGraphic$new(
    fileName = "http://wwww.somefile.org/png",
    fileDescription = "Map Overview",
    fileType = "image/png"
  )
  md$setGraphicOverview(go)

  #maintenance information
  mi <- ISOMaintenanceInformation$new()
  mi$setMaintenanceFrequency("daily")
  md$setResourceMaintenance(mi)

  #adding legal constraints
  lc <- ISOLegalConstraints$new()
  lc$addUseLimitation("limitation1")
  lc$addUseLimitation("limitation2")
  lc$addUseLimitation("limitation3")
  lc$addAccessConstraint("copyright")
  lc$addAccessConstraint("license")
  lc$addUseConstraint("copyright")
  lc$addUseConstraint("license")
  md$setResourceConstraints(lc)

  xml <- md$encode()
   
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{identification}
\keyword{service}
