% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOServiceIdentification.R
\docType{class}
\name{ISOServiceIdentification}
\alias{ISOServiceIdentification}
\title{ISOServiceIdentification}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO ServiceIdentification
}
\description{
ISOServiceIdentification

ISOServiceIdentification
}
\examples{
  #encoding
  md <- ISOServiceIdentification$new()
  md$setAbstract("abstract")
  md$setPurpose("purpose")

  #adding a point of contact
  rp <- ISOResponsibleParty$new()
  rp$setIndividualName("someone")
  rp$setOrganisationName("somewhere")
  rp$setPositionName("someposition")
  rp$setRole("pointOfContact")
  contact <- ISOContact$new()
  phone <- ISOTelephone$new()
  phone$setVoice("myphonenumber")
  phone$setFacsimile("myfacsimile")
  contact$setPhone(phone)
  address <- ISOAddress$new()
  address$setDeliveryPoint("theaddress")
  address$setCity("thecity")
  address$setPostalCode("111")
  address$setCountry("France")
  address$setEmail("someone@theorg.org")
  contact$setAddress(address)
  res <- ISOOnlineResource$new()
  res$setLinkage("http://www.somewhereovertheweb.org")
  res$setName("somename")
  contact$setOnlineResource(res)
  rp$setContactInfo(contact)
  md$addPointOfContact(rp)

  #citation
  ct <- ISOCitation$new()
  ct$setTitle("sometitle")
  d <- ISODate$new()
  d$setDate(ISOdate(2015, 1, 1, 1))
  d$setDateType("publication")
  ct$addDate(d)
  ct$setEdition("1.0")
  ct$setEditionDate(ISOdate(2015,1,1))
  ct$addIdentifier(ISOMetaIdentifier$new(code = "identifier"))
  ct$addPresentationForm("mapDigital")
  ct$addCitedResponsibleParty(rp)
  md$setCitation(ct)

  #graphic overview
  go <- ISOBrowseGraphic$new(
    fileName = "http://wwww.somefile.org/png",
    fileDescription = "Map Overview",
    fileType = "image/png"
  )
  md$addGraphicOverview(go)

  #maintenance information
  mi <- ISOMaintenanceInformation$new()
  mi$setMaintenanceFrequency("daily")
  md$addResourceMaintenance(mi)

  #adding legal constraints
  lc <- ISOLegalConstraints$new()
  lc$addUseLimitation("limitation1")
  lc$addUseLimitation("limitation2")
  lc$addUseLimitation("limitation3")
  lc$addAccessConstraint("copyright")
  lc$addAccessConstraint("license")
  lc$addUseConstraint("copyright")
  lc$addUseConstraint("license")
  md$addResourceConstraints(lc)

  xml <- md$encode()
   
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{identification}
\keyword{service}
\section{Super classes}{
\code{\link[geometa:geometaLogger]{geometa::geometaLogger}} -> \code{\link[geometa:ISOAbstractObject]{geometa::ISOAbstractObject}} -> \code{\link[geometa:ISOIdentification]{geometa::ISOIdentification}} -> \code{ISOServiceIdentification}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ISOServiceIdentification-new}{\code{ISOServiceIdentification$new()}}
\item \href{#method-ISOServiceIdentification-clone}{\code{ISOServiceIdentification$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="ERROR"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-ERROR'><code>geometa::geometaLogger$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="INFO"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-INFO'><code>geometa::geometaLogger$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="WARN"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-WARN'><code>geometa::geometaLogger$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addFieldAttrs"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addFieldAttrs'><code>geometa::ISOAbstractObject$addFieldAttrs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addListElement'><code>geometa::ISOAbstractObject$addListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="contains"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-contains'><code>geometa::ISOAbstractObject$contains()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="createLocalisedProperty"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-createLocalisedProperty'><code>geometa::ISOAbstractObject$createLocalisedProperty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="decode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-decode'><code>geometa::ISOAbstractObject$decode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="delListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-delListElement'><code>geometa::ISOAbstractObject$delListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="encode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-encode'><code>geometa::ISOAbstractObject$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClass"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClass'><code>geometa::ISOAbstractObject$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClassName"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClassName'><code>geometa::ISOAbstractObject$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getNamespaceDefinition"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getNamespaceDefinition'><code>geometa::ISOAbstractObject$getNamespaceDefinition()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isDocument"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isDocument'><code>geometa::ISOAbstractObject$isDocument()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isFieldInheritedFrom"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isFieldInheritedFrom'><code>geometa::ISOAbstractObject$isFieldInheritedFrom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="print"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-print'><code>geometa::ISOAbstractObject$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="save"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-save'><code>geometa::ISOAbstractObject$save()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setAttr"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setAttr'><code>geometa::ISOAbstractObject$setAttr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeList"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeList'><code>geometa::ISOAbstractObject$setCodeList()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeListValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeListValue'><code>geometa::ISOAbstractObject$setCodeListValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeSpace"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeSpace'><code>geometa::ISOAbstractObject$setCodeSpace()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setHref"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setHref'><code>geometa::ISOAbstractObject$setHref()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setId"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setId'><code>geometa::ISOAbstractObject$setId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setIsNull"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setIsNull'><code>geometa::ISOAbstractObject$setIsNull()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setValue'><code>geometa::ISOAbstractObject$setValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="validate"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-validate'><code>geometa::ISOAbstractObject$validate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="wrapBaseElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-wrapBaseElement'><code>geometa::ISOAbstractObject$wrapBaseElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification" data-id="addAggregateInformation"><a href='../../geometa/html/ISOIdentification.html#method-ISOIdentification-addAggregateInformation'><code>geometa::ISOIdentification$addAggregateInformation()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification" data-id="addCredit"><a href='../../geometa/html/ISOIdentification.html#method-ISOIdentification-addCredit'><code>geometa::ISOIdentification$addCredit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification" data-id="addFormat"><a href='../../geometa/html/ISOIdentification.html#method-ISOIdentification-addFormat'><code>geometa::ISOIdentification$addFormat()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification" data-id="addGraphicOverview"><a href='../../geometa/html/ISOIdentification.html#method-ISOIdentification-addGraphicOverview'><code>geometa::ISOIdentification$addGraphicOverview()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification" data-id="addKeywords"><a href='../../geometa/html/ISOIdentification.html#method-ISOIdentification-addKeywords'><code>geometa::ISOIdentification$addKeywords()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification" data-id="addPointOfContact"><a href='../../geometa/html/ISOIdentification.html#method-ISOIdentification-addPointOfContact'><code>geometa::ISOIdentification$addPointOfContact()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification" data-id="addResourceConstraints"><a href='../../geometa/html/ISOIdentification.html#method-ISOIdentification-addResourceConstraints'><code>geometa::ISOIdentification$addResourceConstraints()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification" data-id="addResourceMaintenance"><a href='../../geometa/html/ISOIdentification.html#method-ISOIdentification-addResourceMaintenance'><code>geometa::ISOIdentification$addResourceMaintenance()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification" data-id="addStatus"><a href='../../geometa/html/ISOIdentification.html#method-ISOIdentification-addStatus'><code>geometa::ISOIdentification$addStatus()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification" data-id="delAggregateInformation"><a href='../../geometa/html/ISOIdentification.html#method-ISOIdentification-delAggregateInformation'><code>geometa::ISOIdentification$delAggregateInformation()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification" data-id="delCredit"><a href='../../geometa/html/ISOIdentification.html#method-ISOIdentification-delCredit'><code>geometa::ISOIdentification$delCredit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification" data-id="delFormat"><a href='../../geometa/html/ISOIdentification.html#method-ISOIdentification-delFormat'><code>geometa::ISOIdentification$delFormat()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification" data-id="delGraphicOverview"><a href='../../geometa/html/ISOIdentification.html#method-ISOIdentification-delGraphicOverview'><code>geometa::ISOIdentification$delGraphicOverview()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification" data-id="delKeywords"><a href='../../geometa/html/ISOIdentification.html#method-ISOIdentification-delKeywords'><code>geometa::ISOIdentification$delKeywords()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification" data-id="delPointOfContact"><a href='../../geometa/html/ISOIdentification.html#method-ISOIdentification-delPointOfContact'><code>geometa::ISOIdentification$delPointOfContact()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification" data-id="delResourceConstraints"><a href='../../geometa/html/ISOIdentification.html#method-ISOIdentification-delResourceConstraints'><code>geometa::ISOIdentification$delResourceConstraints()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification" data-id="delResourceMaintenance"><a href='../../geometa/html/ISOIdentification.html#method-ISOIdentification-delResourceMaintenance'><code>geometa::ISOIdentification$delResourceMaintenance()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification" data-id="delStatus"><a href='../../geometa/html/ISOIdentification.html#method-ISOIdentification-delStatus'><code>geometa::ISOIdentification$delStatus()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification" data-id="setAbstract"><a href='../../geometa/html/ISOIdentification.html#method-ISOIdentification-setAbstract'><code>geometa::ISOIdentification$setAbstract()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification" data-id="setCitation"><a href='../../geometa/html/ISOIdentification.html#method-ISOIdentification-setCitation'><code>geometa::ISOIdentification$setCitation()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification" data-id="setGraphicOverview"><a href='../../geometa/html/ISOIdentification.html#method-ISOIdentification-setGraphicOverview'><code>geometa::ISOIdentification$setGraphicOverview()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification" data-id="setKeywords"><a href='../../geometa/html/ISOIdentification.html#method-ISOIdentification-setKeywords'><code>geometa::ISOIdentification$setKeywords()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification" data-id="setPurpose"><a href='../../geometa/html/ISOIdentification.html#method-ISOIdentification-setPurpose'><code>geometa::ISOIdentification$setPurpose()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification" data-id="setResourceConstraints"><a href='../../geometa/html/ISOIdentification.html#method-ISOIdentification-setResourceConstraints'><code>geometa::ISOIdentification$setResourceConstraints()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification" data-id="setResourceMaintenance"><a href='../../geometa/html/ISOIdentification.html#method-ISOIdentification-setResourceMaintenance'><code>geometa::ISOIdentification$setResourceMaintenance()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOServiceIdentification-new"></a>}}
\if{latex}{\out{\hypertarget{method-ISOServiceIdentification-new}{}}}
\subsection{Method \code{new()}}{
Initializes object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOServiceIdentification$new(xml = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link{XMLInternalNode-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOServiceIdentification-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ISOServiceIdentification-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOServiceIdentification$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
