% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOImageryProcessStep.R
\docType{class}
\name{ISOImageryProcessStep}
\alias{ISOImageryProcessStep}
\title{ISOImageryProcessStep}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} for modelling an ISO imagery process step
}
\description{
ISOImageryProcessStep

ISOImageryProcessStep
}
\examples{
   ps <- ISOImageryProcessStep$new()
   ps$setDescription("description")
   ps$setRationale("rationale")
   ps$setDateTime( ISOdate(2015, 1, 1, 23, 59, 59))
   rp <- ISOResponsibleParty$new()
   rp$setIndividualName("someone") #and more responsible party properties..
   ps$addProcessor(rp)
   
   #specific methods to ISO 19115-2
   process <- ISOImageryProcessing$new()
   
   #add citation
   rp1 <- ISOResponsibleParty$new()
   rp1$setIndividualName("someone1")
   rp1$setOrganisationName("somewhere1")
   rp1$setPositionName("someposition1")
   rp1$setRole("pointOfContact")
   contact1 <- ISOContact$new()
   phone1 <- ISOTelephone$new()
   phone1$setVoice("myphonenumber1")
   phone1$setFacsimile("myfacsimile1")
   contact1$setPhone(phone1)
   address1 <- ISOAddress$new()
   address1$setDeliveryPoint("theaddress1")
   address1$setCity("thecity1")
   address1$setPostalCode("111")
   address1$setCountry("France")
   address1$setEmail("someone1@theorg.org")
   contact1$setAddress(address1)
   res <- ISOOnlineResource$new()
   res$setLinkage("http://www.somewhereovertheweb.org")
   res$setName("somename")
   contact1$setOnlineResource(res)
   rp1$setContactInfo(contact1)
   
   #citation
   ct <- ISOCitation$new()
   ct$setTitle("sometitle")
   d <- ISODate$new()
   d$setDate(ISOdate(2015, 1, 1, 1))
   d$setDateType("publication")
   ct$addDate(d)
   ct$setEdition("1.0")
   ct$setEditionDate(ISOdate(2015,1,1))
   ct$addIdentifier(ISOMetaIdentifier$new(code = "identifier"))
   ct$addPresentationForm("mapDigital")
   ct$addCitedResponsibleParty(rp1)
   
   process$setIdentifier("identifier")
   process$setProcedureDescription("some description")
   process$addSoftwareReference(ct)
   process$addDocumentation(ct)
   process$setRunTimeParameters("params")
   ps$setProcessingInformation(process)
  
   #output
   trg <- ISOImagerySource$new()
   trg$setProcessedLevel("level")
   res <- ISOImageryNominalResolution$new()
   d <- ISODistance$new(value = 1, uom = "m", useUomURI = TRUE)
   res$setScanningResolution(d)
   trg$setResolution(res)
   ps$addOutput(trg)
   
   #report
   rep <- ISOImageryProcessStepReport$new()
   rep$setName("report")
   rep$setDescription("description")
   rep$setFileType("filetype")
   ps$addReport(rep)
   
   xml <- ps$encode()  

}
\references{
- ISO 19139 \url{https://schemas.isotc211.org/19115/-2/gmi/1.0/gmi/#element_LE_ProcessStep}
  
  - ISO 19115-3 \url{https://schemas.isotc211.org/19115/-3/mrl/2.0/mrl/#element_LE_ProcessStep}
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{imagery}
\keyword{process}
\keyword{step}
\section{Super classes}{
\code{\link[geometa:geometaLogger]{geometa::geometaLogger}} -> \code{\link[geometa:ISOAbstractObject]{geometa::ISOAbstractObject}} -> \code{\link[geometa:ISOProcessStep]{geometa::ISOProcessStep}} -> \code{ISOImageryProcessStep}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{processingInformation}}{processingInformation [0..1]: ISOImageryProcessing}

\item{\code{output}}{output [0..*]: list of ISOImagerySource}

\item{\code{report}}{report [0..*]: list of ISOImageryProcessStepReport}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ISOImageryProcessStep-new}{\code{ISOImageryProcessStep$new()}}
\item \href{#method-ISOImageryProcessStep-setProcessingInformation}{\code{ISOImageryProcessStep$setProcessingInformation()}}
\item \href{#method-ISOImageryProcessStep-addOutput}{\code{ISOImageryProcessStep$addOutput()}}
\item \href{#method-ISOImageryProcessStep-delOutput}{\code{ISOImageryProcessStep$delOutput()}}
\item \href{#method-ISOImageryProcessStep-addReport}{\code{ISOImageryProcessStep$addReport()}}
\item \href{#method-ISOImageryProcessStep-delReport}{\code{ISOImageryProcessStep$delReport()}}
\item \href{#method-ISOImageryProcessStep-clone}{\code{ISOImageryProcessStep$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="ERROR"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-ERROR'><code>geometa::geometaLogger$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="INFO"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-INFO'><code>geometa::geometaLogger$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="WARN"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-WARN'><code>geometa::geometaLogger$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addFieldAttrs"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addFieldAttrs'><code>geometa::ISOAbstractObject$addFieldAttrs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addListElement'><code>geometa::ISOAbstractObject$addListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="checkMetadataStandardCompliance"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-checkMetadataStandardCompliance'><code>geometa::ISOAbstractObject$checkMetadataStandardCompliance()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="contains"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-contains'><code>geometa::ISOAbstractObject$contains()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="createLocalisedProperty"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-createLocalisedProperty'><code>geometa::ISOAbstractObject$createLocalisedProperty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="decode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-decode'><code>geometa::ISOAbstractObject$decode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="delListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-delListElement'><code>geometa::ISOAbstractObject$delListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="encode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-encode'><code>geometa::ISOAbstractObject$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClass"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClass'><code>geometa::ISOAbstractObject$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClassName"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClassName'><code>geometa::ISOAbstractObject$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getNamespaceDefinition"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getNamespaceDefinition'><code>geometa::ISOAbstractObject$getNamespaceDefinition()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isDocument"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isDocument'><code>geometa::ISOAbstractObject$isDocument()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isFieldInheritedFrom"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isFieldInheritedFrom'><code>geometa::ISOAbstractObject$isFieldInheritedFrom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="print"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-print'><code>geometa::ISOAbstractObject$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="save"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-save'><code>geometa::ISOAbstractObject$save()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setAttr"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setAttr'><code>geometa::ISOAbstractObject$setAttr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeList"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeList'><code>geometa::ISOAbstractObject$setCodeList()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeListValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeListValue'><code>geometa::ISOAbstractObject$setCodeListValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeSpace"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeSpace'><code>geometa::ISOAbstractObject$setCodeSpace()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setHref"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setHref'><code>geometa::ISOAbstractObject$setHref()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setId"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setId'><code>geometa::ISOAbstractObject$setId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setIsNull"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setIsNull'><code>geometa::ISOAbstractObject$setIsNull()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setValue'><code>geometa::ISOAbstractObject$setValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="stopIfMetadataStandardIsNot"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-stopIfMetadataStandardIsNot'><code>geometa::ISOAbstractObject$stopIfMetadataStandardIsNot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="validate"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-validate'><code>geometa::ISOAbstractObject$validate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="wrapBaseElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-wrapBaseElement'><code>geometa::ISOAbstractObject$wrapBaseElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOProcessStep" data-id="addProcessor"><a href='../../geometa/html/ISOProcessStep.html#method-ISOProcessStep-addProcessor'><code>geometa::ISOProcessStep$addProcessor()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOProcessStep" data-id="addSource"><a href='../../geometa/html/ISOProcessStep.html#method-ISOProcessStep-addSource'><code>geometa::ISOProcessStep$addSource()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOProcessStep" data-id="delProcessor"><a href='../../geometa/html/ISOProcessStep.html#method-ISOProcessStep-delProcessor'><code>geometa::ISOProcessStep$delProcessor()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOProcessStep" data-id="delSource"><a href='../../geometa/html/ISOProcessStep.html#method-ISOProcessStep-delSource'><code>geometa::ISOProcessStep$delSource()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOProcessStep" data-id="setDateTime"><a href='../../geometa/html/ISOProcessStep.html#method-ISOProcessStep-setDateTime'><code>geometa::ISOProcessStep$setDateTime()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOProcessStep" data-id="setDescription"><a href='../../geometa/html/ISOProcessStep.html#method-ISOProcessStep-setDescription'><code>geometa::ISOProcessStep$setDescription()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOProcessStep" data-id="setRationale"><a href='../../geometa/html/ISOProcessStep.html#method-ISOProcessStep-setRationale'><code>geometa::ISOProcessStep$setRationale()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImageryProcessStep-new"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImageryProcessStep-new}{}}}
\subsection{Method \code{new()}}{
Initializes object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImageryProcessStep$new(xml = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link[XML]{XMLInternalNode-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImageryProcessStep-setProcessingInformation"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImageryProcessStep-setProcessingInformation}{}}}
\subsection{Method \code{setProcessingInformation()}}{
Set processing info
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImageryProcessStep$setProcessingInformation(processingInfo)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{processingInfo}}{object of class \link{ISOImageryProcessing}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImageryProcessStep-addOutput"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImageryProcessStep-addOutput}{}}}
\subsection{Method \code{addOutput()}}{
Adds output
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImageryProcessStep$addOutput(output)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{output}}{object of class \link{ISOImagerySource}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImageryProcessStep-delOutput"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImageryProcessStep-delOutput}{}}}
\subsection{Method \code{delOutput()}}{
Deletes output
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImageryProcessStep$delOutput(output)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{output}}{object of class \link{ISOImagerySource}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImageryProcessStep-addReport"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImageryProcessStep-addReport}{}}}
\subsection{Method \code{addReport()}}{
Adds report
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImageryProcessStep$addReport(report)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{report}}{object of class \link{ISOImageryProcessStepReport}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImageryProcessStep-delReport"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImageryProcessStep-delReport}{}}}
\subsection{Method \code{delReport()}}{
Deletes report
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImageryProcessStep$delReport(report)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{report}}{object of class \link{ISOImageryProcessStepReport}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImageryProcessStep-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImageryProcessStep-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImageryProcessStep$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
