% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gc_sf.R
\docType{methods}
\name{gc_sf}
\alias{gc_sf}
\alias{gc_sf,geom-method}
\title{Transform a spatial object to class \code{sf}}
\usage{
\S4method{gc_sf}{geom}(input = NULL)
}
\arguments{
\item{input}{the object to transform to class \code{sf}.}
}
\value{
If \code{input} is a \code{geom} and has attributes other than
  \code{fid} and \code{gid}, a "Simple feature collection", otherwise a
  "Geometry set". Several features of the \code{geom} are returned as MULTI*
  feature, when they have \code{gid} and optionally other attributes in
  common, otherwise they are returned as a single simple feature.
}
\description{
Transform a spatial object to class \code{sf}
}
\examples{
sfPoints <- gc_sf(input = gtGeoms$point)
sfLines <- gc_sf(input = gtGeoms$line)
sfPolygon <- gc_sf(input = gtGeoms$polygon)
}
\seealso{
Other spatial classes: \code{\link{gc_geom}},
  \code{\link{gc_grob}}, \code{\link{gc_ppp}},
  \code{\link{gc_sp}}
}
\concept{spatial classes}
