% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/read.ply.r
\name{read.ply}
\alias{read.ply}
\title{Read mesh data (vertices and faces) from ply files}
\usage{
read.ply(file, ShowSpecimen = TRUE, addNormals = TRUE)
}
\arguments{
\item{file}{An ASCII ply file}

\item{ShowSpecimen}{logical Indicating whether or not the ply file should be displayed}

\item{addNormals}{logical Indicating whether or not the normals of each vertex should be calculated (using \code{\link[rgl]{addNormals}})}
}
\value{
Function returns the following components:
  \item{mesh3d}{list of class mesh3d- see rgl for details}
}
\description{
A function to read ply files, which can be used for digitizing landmark coordinates or for shape warps.
}
\details{
Function reads three-dimensional surface data in the form of a single ply file
 (Polygon File Format; ASCII format only, from 3D scanners such as NextEngine and David scanners).
 Vertices of the surface may then be used to digitize three-dimensional points,
 and semilandmarks on curves and surfaces. The surface may also be used as a mesh for visualizing 3D deformations (\code{\link{warpRefMesh}}).
 The function opens the ply file and plots the mesh,
 with faces rendered if file contains faces, and colored if the file contains vertex color.
 Vertex normals allow better visualization and more accurate digitizing with \code{\link{digit.fixed}}.
}
\examples{
# If the file has no mesh color, or color is undesirable, user can assign this as follows:
# Using the example scallop PLY
data(scallopPLY)
myply <- scallopPLY$ply
myply$material <- "gray" # using color word
myply$material <- "#FCE6C9" # using RGB code
}
\author{
Dean Adams & Emma Sherratt
}
\keyword{IO}

