% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSLayerManager.R
\docType{class}
\name{GSLayerManager}
\alias{GSLayerManager}
\title{Geoserver REST API Layer Manager}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with methods for managing GeoServer
Layers as results of published feature types or coverages
}
\description{
Geoserver REST API Layer Manager

Geoserver REST API Layer Manager
}
\examples{
\dontrun{
   GSLayerManager$new("http://localhost:8080/geoserver", "admin", "geoserver")
 }

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{Layer}
\keyword{api}
\keyword{geoserver}
\keyword{rest}
\section{Super class}{
\code{\link[geosapi:GSManager]{geosapi::GSManager}} -> \code{GSLayerManager}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-getLayers}{\code{GSLayerManager$getLayers()}}
\item \href{#method-getLayerNames}{\code{GSLayerManager$getLayerNames()}}
\item \href{#method-getLayer}{\code{GSLayerManager$getLayer()}}
\item \href{#method-createLayer}{\code{GSLayerManager$createLayer()}}
\item \href{#method-updateLayer}{\code{GSLayerManager$updateLayer()}}
\item \href{#method-deleteLayer}{\code{GSLayerManager$deleteLayer()}}
\item \href{#method-getLayerGroups}{\code{GSLayerManager$getLayerGroups()}}
\item \href{#method-getLayerGroupNames}{\code{GSLayerManager$getLayerGroupNames()}}
\item \href{#method-getLayerGroup}{\code{GSLayerManager$getLayerGroup()}}
\item \href{#method-createLayerGroup}{\code{GSLayerManager$createLayerGroup()}}
\item \href{#method-updateLayerGroup}{\code{GSLayerManager$updateLayerGroup()}}
\item \href{#method-deleteLayerGroup}{\code{GSLayerManager$deleteLayerGroup()}}
\item \href{#method-clone}{\code{GSLayerManager$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="connect">}\href{../../geosapi/html/GSManager.html#method-connect}{\code{geosapi::GSManager$connect()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="ERROR">}\href{../../geosapi/html/GSManager.html#method-ERROR}{\code{geosapi::GSManager$ERROR()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getClassName">}\href{../../geosapi/html/GSManager.html#method-getClassName}{\code{geosapi::GSManager$getClassName()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getCoverageStoreManager">}\href{../../geosapi/html/GSManager.html#method-getCoverageStoreManager}{\code{geosapi::GSManager$getCoverageStoreManager()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getDataStoreManager">}\href{../../geosapi/html/GSManager.html#method-getDataStoreManager}{\code{geosapi::GSManager$getDataStoreManager()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getNamespaceManager">}\href{../../geosapi/html/GSManager.html#method-getNamespaceManager}{\code{geosapi::GSManager$getNamespaceManager()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getServiceManager">}\href{../../geosapi/html/GSManager.html#method-getServiceManager}{\code{geosapi::GSManager$getServiceManager()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getStyleManager">}\href{../../geosapi/html/GSManager.html#method-getStyleManager}{\code{geosapi::GSManager$getStyleManager()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getSystemStatus">}\href{../../geosapi/html/GSManager.html#method-getSystemStatus}{\code{geosapi::GSManager$getSystemStatus()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getUrl">}\href{../../geosapi/html/GSManager.html#method-getUrl}{\code{geosapi::GSManager$getUrl()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getWorkspaceManager">}\href{../../geosapi/html/GSManager.html#method-getWorkspaceManager}{\code{geosapi::GSManager$getWorkspaceManager()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="INFO">}\href{../../geosapi/html/GSManager.html#method-INFO}{\code{geosapi::GSManager$INFO()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="initialize">}\href{../../geosapi/html/GSManager.html#method-initialize}{\code{geosapi::GSManager$initialize()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="logger">}\href{../../geosapi/html/GSManager.html#method-logger}{\code{geosapi::GSManager$logger()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="monitor">}\href{../../geosapi/html/GSManager.html#method-monitor}{\code{geosapi::GSManager$monitor()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="reload">}\href{../../geosapi/html/GSManager.html#method-reload}{\code{geosapi::GSManager$reload()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="WARN">}\href{../../geosapi/html/GSManager.html#method-WARN}{\code{geosapi::GSManager$WARN()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getLayers"></a>}}
\if{latex}{\out{\hypertarget{method-getLayers}{}}}
\subsection{Method \code{getLayers()}}{
Get the list of layers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerManager$getLayers()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
an object of class \code{list} giving items of class \code{\link{GSLayer}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getLayerNames"></a>}}
\if{latex}{\out{\hypertarget{method-getLayerNames}{}}}
\subsection{Method \code{getLayerNames()}}{
Get the list of layer names.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerManager$getLayerNames()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a vector of class \code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getLayer"></a>}}
\if{latex}{\out{\hypertarget{method-getLayer}{}}}
\subsection{Method \code{getLayer()}}{
Get layer by name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerManager$getLayer(lyr)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lyr}}{layer name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \link{GSLayer}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-createLayer"></a>}}
\if{latex}{\out{\hypertarget{method-createLayer}{}}}
\subsection{Method \code{createLayer()}}{
Creates a new layer given an object of class \code{\link{GSLayer}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerManager$createLayer(layer)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{layer}}{object of class \link{GSLayer}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if created, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateLayer"></a>}}
\if{latex}{\out{\hypertarget{method-updateLayer}{}}}
\subsection{Method \code{updateLayer()}}{
Updates a layer given an object of class \code{\link{GSLayer}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerManager$updateLayer(layer)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{layer}}{object of class \link{GSLayer}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if updated, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-deleteLayer"></a>}}
\if{latex}{\out{\hypertarget{method-deleteLayer}{}}}
\subsection{Method \code{deleteLayer()}}{
Deletes layer given an object of class \code{\link{GSLayer}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerManager$deleteLayer(lyr)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lyr}}{layer name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getLayerGroups"></a>}}
\if{latex}{\out{\hypertarget{method-getLayerGroups}{}}}
\subsection{Method \code{getLayerGroups()}}{
Get layer groups
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerManager$getLayerGroups(ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name. Optional}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a list of objects of class \link{GSLayerGroup}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getLayerGroupNames"></a>}}
\if{latex}{\out{\hypertarget{method-getLayerGroupNames}{}}}
\subsection{Method \code{getLayerGroupNames()}}{
Get layer group names
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerManager$getLayerGroupNames(ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{workspace name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a list of layer group names, as vector of class \code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getLayerGroup"></a>}}
\if{latex}{\out{\hypertarget{method-getLayerGroup}{}}}
\subsection{Method \code{getLayerGroup()}}{
Get layer group
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerManager$getLayerGroup(lyr, ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lyr}}{lyr}

\item{\code{ws}}{workspace name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \link{GSLayerGroup}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-createLayerGroup"></a>}}
\if{latex}{\out{\hypertarget{method-createLayerGroup}{}}}
\subsection{Method \code{createLayerGroup()}}{
Creates a layer group
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerManager$createLayerGroup(layerGroup, ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{layerGroup}}{object of class \link{GSLayerGroup}}

\item{\code{ws}}{workspace name. Optional}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if created, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateLayerGroup"></a>}}
\if{latex}{\out{\hypertarget{method-updateLayerGroup}{}}}
\subsection{Method \code{updateLayerGroup()}}{
Updates a layer group
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerManager$updateLayerGroup(layerGroup, ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{layerGroup}}{object of class \link{GSLayerGroup}}

\item{\code{ws}}{workspace name. Optional}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if updated, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-deleteLayerGroup"></a>}}
\if{latex}{\out{\hypertarget{method-deleteLayerGroup}{}}}
\subsection{Method \code{deleteLayerGroup()}}{
Deletes a layer group
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerManager$deleteLayerGroup(lyr, ws = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lyr}}{layer group name}

\item{\code{ws}}{workspace name. Optional}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerManager$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
