# author of original JavaScript code: Chris Vennes
# (c) 2002-2009 Chris Veness
# http://www.movable-type.co.uk/scripts/latlong.html
# Licence: LGPL, without any warranty express or implied

# Port to R by Robert Hijmans
# October 2009
# version 0.1
# license GPL3



distHaversine <- function(p1, p2, r=6378137) {
#* Haversine formula to calculate distance between two points specified by 
#* from: Haversine formula - r. W. Sinnott, "Virtues of the Haversine",
#*  Sky and Telescope, vol 68, no 2, 1984
#*  http:#//www.census.gov/cgi-bin/geo/gisfaq?Q5.1

# source http://www.movable-type.co.uk/scripts/latlong.html
# (c) 2002-2009 Chris Veness
	toRad <- pi / 180 
	p1 <- .pointsToMatrix(p1) * toRad
	p2 <- .pointsToMatrix(p2) * toRad

	.compareDim(p1, p2)

	lon1 <- p1[,1]
	lat1 <- p1[,2]
	lon2 <- p2[,1]
	lat2 <- p2[,2]
  
	dLat <- (lat2-lat1)
	dLon <- (lon2-lon1)
	a <- sin(dLat/2) * sin(dLat/2) + cos(lat1) * cos(lat2) * sin(dLon/2) * sin(dLon/2)
	c <- 2 * atan2(sqrt(a), sqrt(1-a))
	dist <- r * c

	if (is.vector(dist)) { dist <- matrix(dist) }
	colnames(dist) <- 'distance'

	return(dist)
}
