% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/york.R
\name{york}
\alias{york}
\title{Linear regression of X,Y-variables with correlated errors}
\usage{
york(dat, alpha = 0.05, plot = TRUE, fill = NA, ...)
}
\arguments{
\item{dat}{a 4 or 5-column matrix with the X-values, the analytical
uncertainties of the X-values, the Y-values, the analytical
uncertainties of the Y-values, and (optionally) the correlation
coefficients of the X- and Y-values.}

\item{alpha}{cutoff value for confidence intervals.}

\item{plot}{logical. If true, creates a scatter plot of the data
with the best fit line shown on it.}

\item{fill}{the fill colour of the error ellipses. For additional
plot options, use the \code{IsoplotR} package.}

\item{...}{optional arguments for the scatter plot.}
}
\value{
A two-element list of vectors containing:

    \describe{

    \item{coef}{the intercept and slope of the straight line fit}

    \item{cov}{the covariance matrix of the coefficients}

    }
}
\description{
Implements the unified regression algorithm of York et al. (2004)
which, although based on least squares, yields results that are
consistent with maximum likelihood estimates of Titterington and
Halliday (1979).
}
\details{
Given n pairs of (approximately) collinear measurements \eqn{X_i}
and \eqn{Y_i} (for \eqn{1 \leq i \leq n}), their uncertainties
\eqn{s[X_i]} and \eqn{s[Y_i]}, and their covariances
cov[\eqn{X_i,Y_i}], the \code{york} function finds the best fitting
straight line using the least-squares algorithm of York et
al. (2004). This algorithm is modified from an earlier method
developed by York (1968) to be consistent with the maximum
likelihood approach of Titterington and Halliday (1979).
}
\examples{
data(rbsr,package='geostats')
fit <- york(rbsr)
}
\references{
Titterington, D.M. and Halliday, A.N., 1979. On the fitting of
parallel isochrons and the method of maximum likelihood. Chemical
Geology, 26(3), pp.183-195.

York, Derek, et al., 2004. Unified equations for the slope,
intercept, and standard errors of the best straight line.  American
Journal of Physics 72.3, pp.367-375.
}
