% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_country_report.R
\name{render_country_report}
\alias{render_country_report}
\title{Render a Country Level TB Report}
\usage{
render_country_report(country = "United Kingdom",
  format = "html_document", interactive = FALSE, save_dir = NULL,
  filename = NULL)
}
\arguments{
\item{country}{Character string, defaults to \code{"United Kingdom"}. Specify the country to
report on.}

\item{format}{Character string, defaults to \code{"html_document"}. The format to render the report to.
See \code{?rmarkdown::render} for details.}

\item{interactive}{Logical, defaults to \code{FALSE}. When the format allows should graphs be interactive.}

\item{save_dir}{Character string, defaults to \code{NULL}.
If not given then the report is rendered to a temporary directory (although only if \code{filename} is also not given).}

\item{filename}{Character string defaults \code{NULL}. Name to save the report under, defaults to \code{"country_report"}.}
}
\value{
Renders a country level TB report
}
\description{
This function renders a country level TB report.
}
\examples{

## Only run the example if in an interative session
\dontrun{

## Run the TB dashboard
render_country_report()
}
}
