% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsat_list.R
\name{lsat_list}
\alias{lsat_list}
\title{List Landsat images}
\usage{
lsat_list(max = NULL, marker = NULL, prefix = NULL, delimiter = NULL,
  ...)
}
\arguments{
\item{max}{(integer) number indicating the maximum number of keys to
return (max 1000, default 1000).}

\item{marker}{(character) string that pecifies the key to start with
when listing objects in a AWS bucket. Amazon S3 returns object keys in
alphabetical order, starting with key after the marker in order}

\item{prefix}{(character) string that limits the response to keys
that begin with the specified prefix}

\item{delimiter}{(character) string used to group keys. Read the AWS
doc for more detail.}

\item{...}{curl args passed on to \code{\link[httr]{GET}}}
}
\description{
List Landsat images
}
\details{
This is an alternative to using \code{\link{lsat_scenes}}. This
function uses the AWS S3 API, while \code{\link{lsat_scenes}} downloads
the up to date compressed csv file.
}
\examples{
\dontrun{
lsat_list(max = 10)

# paging, start a specific key string
res <- lsat_list(max = 10)
lsat_list(marker = res$Key[10], max = 10)

# curl options
library("httr")
lsat_list(max = 3, config = verbose())
}
}

