% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isatpanel.R
\name{isatpanel}
\alias{isatpanel}
\title{Indicator Saturation for Panel Data}
\usage{
isatpanel(
  data = NULL,
  formula = NULL,
  index = NULL,
  effect = c("individual"),
  na.remove = TRUE,
  engine = NULL,
  user.estimator = NULL,
  cluster = "none",
  ar = 0,
  iis = FALSE,
  jiis = FALSE,
  jsis = FALSE,
  fesis = FALSE,
  csis = FALSE,
  cfesis = FALSE,
  csis_var = colnames(mxreg),
  fesis_id = NULL,
  cfesis_var = colnames(mxreg),
  cfesis_id = NULL,
  uis = NULL,
  t.pval = 0.001,
  plot = TRUE,
  plm_model = "within",
  y = NULL,
  id = NULL,
  time = NULL,
  mxreg = NULL,
  ...
)
}
\arguments{
\item{data}{The input data.frame object.}

\item{formula}{Please specify a formula argument. The dependent variable will be the left-most element, separated by a ~ symbol from the remaining regressors. Note the intercept will always be removed, if effect is not "none" - this means that if any fixed effects are specified, the intercept will always be removed.}

\item{index}{Specify the name of the group and time column in the format c("id", "time").}

\item{effect}{Fixed Effect specification. Possible arguments: "twoways", "individual", "time", or "none".}

\item{na.remove}{remove NAs}

\item{engine}{Estimation function to use. Default is NULL, which uses the default estimation procedure of the gets package. Alternatives are "fixest", "plm", or "felm".}

\item{user.estimator}{Use a user.estimator}

\item{cluster}{cluster Standard Errors at this level. Default is "none". Possible values are: "individual", "time", or "twoways".}

\item{ar}{Autoregressive Term to be included. default is 0.}

\item{iis}{Logical. Use Impulse Indicator Saturation.}

\item{jiis}{Logical. Use Joint Impulse Indicator Saturation (Outliers are common across all units). This is essentially just a time fixed effect, but this allows selection of FE.}

\item{jsis}{Logical. Use Join Step Indicator Saturation (steps are common across all units). Will only be retained if time fixed effects are not included (i.e. effect = 'none' or 'individual'), as they are collinear otherwise.}

\item{fesis}{Logical. Use Fixed Effect Step Indicator Saturation. Constructed by multiplying a constant (1) with group Fixed Effects. Default is \code{FALSE}.}

\item{csis}{Logical. Use Coefficient Step Indicator Saturation. Constructed by Default is FALSE.}

\item{cfesis}{Logical. Use Coefficient-Fixed Effect Indicator Saturation. Default is FALSE.}

\item{csis_var}{The csis method can be conducted for all (default) variables or just a subset of them. If you want to use a subset, please specify the column names of the variable in a character vector.}

\item{fesis_id}{The fesis method can be conducted for all (default) individuals/units (i.e. looking for breaks in individual countries) or just a subset of them (joint breaks in the coefficients for a few individuals). If you want to use a subset, please specify the individuals/units for which you want to test the stability in a character vector.}

\item{cfesis_var}{The cfesis method can be conducted for all variables (default) or just a subset of them. If you want to use a subset, please specify the column names of the variable in a character vector.}

\item{cfesis_id}{The cfesis method can be conducted for all individuals/units (default) or just a subset of them. If you want to use a subset, please specify the individuals/units to be tested in a character vector.}

\item{uis}{Matrix or List. This can be used to include a set of UIS (User Specified Indicators). Must be equal to the sample size (so it is recommended to use this only with datasets without \code{NA} values. Default is \code{NULL}. See the reference by Genaro Sucarrat (2020) below for an explanation of the UIS system.}

\item{t.pval}{numeric value between 0 and 1. The significance level used for the two-sided regressor significance t-tests}

\item{plot}{Logical. Should the final object be plotted? Default is TRUE. The output is a combination of \code{plot} and \code{\link[=plot_grid]{plot_grid()}} using the \code{cowplot} package.}

\item{plm_model}{Type of PLM model (only if engine = "PLM")}

\item{y}{Deprecated. The dependent variable. Can be used when data, index, and formula are not specified.}

\item{id}{Deprecated. Can be used when data, index, and formula are not specified. Must be a vector of the grouping variable as a character or factor}

\item{time}{Deprecated. Can be used when data, index, and formula are not specified. Must be a vector of the time variable as an integer or numeric.}

\item{mxreg}{The co-variates matrix}

\item{...}{Further arguments to \code{\link[gets:isat]{gets::isat()}}}
}
\value{
A list with class 'isatpanel'.
}
\description{
This function is essentially a wrapper function around the \code{\link[gets:isat]{gets::isat()}} function from the \code{gets} package.
This function allows the running of various different indicator saturation techniques that can, for example, be used to answer reverse causal questions.
Indicator Saturation techniques fully saturate a model with indicators (for example dummy-indicators or step-indicators) and then use an automated block-search
algorithm to retain only relevant indicators that improve the model (based on a chosen information criterion).
}
\examples{
\donttest{
data(EU_emissions_road)

# Group specification
EU15 <- c("Austria", "Germany", "Denmark", "Spain", "Finland", "Belgium",
         "France", "United Kingdom", "Ireland", "Italy", "Luxembourg",
         "Netherlands", "Greece", "Portugal", "Sweden")

# Prepare sample and data
EU_emissions_road_short <- EU_emissions_road[
EU_emissions_road$country \%in\% EU15 &
EU_emissions_road$year >= 2000,
]

# Run
result <- isatpanel(
  data = EU_emissions_road_short,
  formula = ltransport.emissions ~ lgdp + I(lgdp^2) + lpop,
  index = c("country", "year"),
  effect = "twoways",
  fesis = TRUE,
  plot = FALSE,
  t.pval = 0.01
)
plot(result)
plot_grid(result)

# print the retained indicators
get_indicators(result)
}
}
\references{
Felix Pretis and Moritz Schwarz (2022). Discovering What Mattered: Answering Reverse Causal Questions by Detecting Unknown Treatment Assignment and Timing as Breaks in Panel Models. January 31, 2022. Available at SSRN: https://ssrn.com/abstract=4022745 or http://dx.doi.org/10.2139/ssrn.4022745

Genaro Sucarrat. User-Specified General-to-Specific and Indicator Saturation Methods, The R Journal (2020) 12:2, pages 388-401. Available at: https://journal.r-project.org/archive/2021/RJ-2021-024/index.html
}
\seealso{
\code{\link[gets:isat]{gets::isat()}}
}
