% Generated by roxygen2 (4.0.1): do not edit by hand
\name{plot_nnm_reconstruction}
\alias{plot_nnm_reconstruction}
\title{MM Algorithm - Plotting the Reconstruction}
\usage{
plot_nnm_reconstruction(nnm, X, nnm_sol)
}
\arguments{
\item{nnm}{NNM object from generate_nnm function}

\item{X}{Nonnegative design matrix}

\item{nnm_sol}{Solution object from nnls_mm function}
}
\description{
\code{plot_nnm_reconstruction} Function for plotting the nnm_sol reconstruction
}
\examples{
# Setup mixture example
n <- 1e3
p <- 10
nnm <- generate_nnm(n,p)

set.seed(12345)
X <- nnm$X
b <- double(p)
nComponents <- 3
k <- sample(1:p,nComponents,replace=FALSE)
b[k] <- matrix(runif(nComponents),ncol=1)
y <- X\%*\%b + 0.25*matrix(abs(rnorm(n)),n,1)

# Obtain solution to mixture problem
nnm_sol <- nnls_mm(y,X,runif(p))

# Plot the reconstruction
plot_nnm_reconstruction(nnm,X,nnm_sol)
}

