test_that("SingBoost is implemented correctly",{
glmres<-glmboost(Sepal.Length~.,iris)
firis<-as.formula(Sepal.Length~.)
Xiris<-model.matrix(firis,iris)
Diris<-data.frame(Xiris[,-1],iris$Sepal.Length)
expect_error(singboost(Diris,m_iter=-2))
expect_error(singboost(Diris,m_iter=8.7))
expect_error(singboost(Diris,kap=-0.2))
expect_error(singboost(Diris,kap=1.1))
expect_error(singboost(Diris,M=3.3))
expect_error(singboost(Diris,M=-1))
expect_error(singboost(Diris,M=200))
ressing<-singboost(Diris)
ressing2<-singboost(Diris,LS=TRUE)
expect_equal(as.numeric(coef(glmres)[-1]),as.numeric(ressing$Var[-1]))
expect_equal(as.numeric(coef(glmres)[-1]),as.numeric(ressing2$Var[-1]))
expect_equal(as.numeric(coef(glmres)[1]+glmres$offset),as.numeric(ressing$Var[1]))
expect_equal(as.numeric(coef(glmres)[1]+glmres$offset),as.numeric(ressing2$Var[1]))
expect_equal(attributes(varimp(glmres))$self,ressing$Freqs)
expect_equal(attributes(varimp(glmres))$self,ressing2$Freqs)
glmres2<-glmboost(Sepal.Length~Petal.Length+Sepal.Width:Species,iris)
finter<-as.formula(Sepal.Length~Petal.Length+Sepal.Width:Species-1)
Xinter<-model.matrix(finter,iris)
Dinter<-data.frame(Xinter,iris$Sepal.Length)
ressing3<-singboost(Dinter)
expect_equal(as.numeric(coef(glmres2)[-1]),as.numeric(ressing3$Var[-1]))
expect_equal(as.numeric(coef(glmres2)[1]+glmres2$offset),as.numeric(ressing3$Coef[1]))
expect_equal(attributes(varimp(glmres2))$self,ressing3$Freqs)
glmres3<-glmboost(Xiris,iris$Sepal.Length,control=boost_control(mstop=250,nu=0.05))
ressing4<-singboost(Diris,m_iter=250,kap=0.05)
ressing5<-singboost(Diris,LS=TRUE,m_iter=250,kap=0.05)
expect_equal(as.numeric(coef(glmres3)[-1]),as.numeric(ressing4$Var[-1]))
expect_equal(as.numeric(coef(glmres3)[1]+glmres3$offset),as.numeric(ressing4$Coef[1]))
expect_equal(attributes(varimp(glmres3))$self,ressing4$Freqs)
expect_equal(as.numeric(coef(glmres3)[-1]),as.numeric(ressing5$Var[-1]))
expect_equal(as.numeric(coef(glmres3)[1]+glmres3$offset),as.numeric(ressing5$Coef[1]))
expect_equal(attributes(varimp(glmres3))$self,ressing5$Freqs)
})